package com.uva.rafael.tfg_goniometer.data.entities;

import android.content.ContentValues;

import com.uva.rafael.tfg_goniometer.data.Contract;
import com.uva.rafael.tfg_goniometer.data.enums.Articulacion;
import com.uva.rafael.tfg_goniometer.data.enums.Lado;

/**
 * Esta clase modela a la <tt>Entity</tt> "ArticulacionInvolucrada" de la Base de Datos.
 *
 * <p>Se encarga de proveer un método para insertar una "Articulacion" en la Base de Datos, pasando
 * cada uno de los atributos que componen esta clase a un formato adecuado, por medio de un objeto
 * de tipo <tt>ContentValues</tt>.</p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Lado
 * @see Articulacion
 * @see ContentValues
 * @see com.uva.rafael.tfg_goniometer.data.Contract.MeasurementEntry
 * @version 1.0
 */

public class ArticulacionInvolucrada {
    // Lado del cuerpo en el que se encuentra la articulación
    private final Lado lado;
    // Articulación en sí
    private final Articulacion articulacion;

    /**
     * Constructor principal de la clase
     *
     * @param lado         Lado del cuerpo en el que se encuentra
     * @param articulacion Articulación en sí
     */
    public ArticulacionInvolucrada(Lado lado, Articulacion articulacion) {
        this.lado = lado;
        this.articulacion = articulacion;
    }

    /*
     * Método que se encarga de dar un formato adecuado a cada uno de los atributos de la clase,
     * para, posteriormente, ser insertados en la Base de Datos.
     *
     * En concreto, recibe una referencia al objeto ContentValues pasado desde la Entity "Medicion"
     * y, simplemente, se encarga de añadir los campos del Lado de la articulación y de la
     * Articulación en sí
     */
    void toContentValues(ContentValues values) {
        // Relacionar el campo de la tabla en la BD con el atributo que corresponde de la clase
        values.put(Contract.MeasurementEntry.LADO, lado.toString());
        /*
         * Para la obtención del ContentValues de la Articulacion, se utiliza el método
         * "toContentValues" de la clase correspondiente, ya que, esta clase no es simplemente un
         * objeto de tipo "Enum" como el Lado, sino que, puede tener otros valores si el usuario
         * selecciona el valor "Otra" al introducir una nueva medición en la BD.
         */
        articulacion.toContentValues(values);
    }
}
