package com.uva.rafael.tfg_goniometer.dependencyInjection;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Scope;

/**
 * Anotación creada para definir el Scope (alcance) de los módulos utilizados para inyectar
 * dependencias, mediante el uso de la biblioteca Dagger 2.
 *
 * <p>Es decir, se utiliza para indicar a la interfaz <tt>Component/tt> que todas las dependencias
 * que tiene, se destruyan una vez que ha terminado la <tt>Activity</tt> principal
 * (<tt>MainActivity</tt>, en este caso).</p>
 *
 * <p>Esta anotación forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Component
 * @version 1.0
 */

@Scope
/*
 * Con la etiqueta @Retention, se indica que una vez que termine el tiempo de ejecución de la
 * aplicación, se destruya la interfaz Component y con ella, todos los módulos que tiene asociados
 * (Module, en este caso)
 */
@Retention(RetentionPolicy.RUNTIME)
@interface ActivityScope {
}
