package com.uva.rafael.tfg_goniometer.dependencyInjection;

import com.uva.rafael.tfg_goniometer.view.MainActivity;
import com.uva.rafael.tfg_goniometer.view.fragments.HomeFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.MedicionFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.NuevaMedicionFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.NuevoPacienteFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.PacientesFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.PerfilPacienteFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.SobreAppFragment;
import com.uva.rafael.tfg_goniometer.view.fragments.UltimasMedicionesFragment;

/**
 * Esta interfaz es un Componente (según la terminología de la biblioteca Dagger 2), indicado
 * mediante la etiqueta <tt>Component</tt> en la definición de la misma.
 *
 * <p>En este caso, este componente utiliza un único módulo (<tt>Module</tt>). Y se encarga de
 * definir los métodos con las <tt>Activities</tt> o <tt>Fragments</tt> donde se va a hacer la
 * inyección de dependencias, es decir, dispone de un método por cada una de las clases donde se va
 * a realizar esa inyección de dependencias.</p>
 *
 * <p>Esta interfaz forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Module
 * @see App
 * @see ActivityScope
 * @version 1.0
 */

@SuppressWarnings("WeakerAccess")
@ActivityScope
@dagger.Component(
        modules = {
                Module.class
        }
)
public interface Component {

    /*
     * Método que se utiliza para inyectar una instancia de tipo MainPresenter en la clase
     * MainActivity
     */
    void injectMainActivity(MainActivity activity);

    /*
     * Método que se utiliza para inyectar una instancia de tipo HomePresenter en la clase
     * HomeFragment
     */
    void injectHomeFragment(HomeFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo MedicionPresenter en la clase
     * MedicionFragment
     */
    void injectMedicionFragment(MedicionFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo PacientesPresenter en la clase
     * PacientesFragment
     */
    void injectPacientesFragment(PacientesFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo NuevoPacientePresenter en la clase
     * NuevoPacienteFragment
     */
    void injectNuevoPacienteFragment(NuevoPacienteFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo PerfilPacientePresenter en la clase
     * PerfilPacienteFragment
     */
    void injectPerfilPacienteFragment(PerfilPacienteFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo NuevaMedicionPresenter en la clase
     * NuevaMedicionFragment
     */
    void injectNuevaMedicionFragment(NuevaMedicionFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo UltimasMedicionesPresenter en la
     * clase UltimasMedicionesFragment
     */
    void injectUltimasMedicionesFragment(UltimasMedicionesFragment fragment);

    /*
     * Método que se utiliza para inyectar una instancia de tipo SobreAppPresenter en la clase
     * SobreAppFragment
     */
    void injectSobreAppFragment(SobreAppFragment fragment);
}
