package com.uva.rafael.tfg_goniometer.view.fragments;

import android.app.Fragment;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import com.uva.rafael.tfg_goniometer.R;
import com.uva.rafael.tfg_goniometer.dependencyInjection.App;
import com.uva.rafael.tfg_goniometer.presenter.HomePresenter;

import javax.inject.Inject;

/**
 * Esta clase es el <tt>Fragment</tt> principal, que se ejecuta en el momento en que el usuario abre
 * la aplicación o pulsa sobre la opción "Home" del menú lateral de la misma.
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informática (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Toolbar
 * @see HomePresenter
 * @version 1.0
 */
public class HomeFragment extends Fragment {

    /*
     * Presentador asociado con este Fragment (Vista). Su instancia se obtiene mediante Inversión
     * de Dependencias
     */
    @SuppressWarnings({"unused", "CanBeFinal"})
    @Inject
    HomePresenter presenter;

    /**
     * Método llamado para instanciar el <tt>Fragment</tt> con su layout asociada
     * (R.layout.home_fragment, en este caso). Además de eso, se encarga de notificar a
     * <tt>HomePresenter</tt> cuando el usuario pulse sobre alguno de los botones que posee el
     * layout.
     *
     * @param inflater The LayoutInflater object that can be used to inflate any view in the
     *                 fragment.
     * @param container If non-null, this is the parent view that the fragment's UI should be
     *                  attached to. The fragment should not add the view itself, but this can be
     *                  used to generate the LayoutParams of the view.
     * @param savedInstanceState If non-null, this fragment is being re-constructed from a previous
     *                           saved state as given here. Return the View for the fragment's UI,
     *                           or null.
     */
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             Bundle savedInstanceState) {

        // Obtención de la instancia de HomePresenter
        ((App) getActivity().getApplication()).getComponent(this).injectHomeFragment(this);

        // Inflar el layout del Fragment
        View vista = inflater.inflate(R.layout.home_fragment, container, false);

        // Bindeo del Toolbar
        Toolbar toolbar = (Toolbar) vista.findViewById(R.id.toolbar);

        // Configuración inicial
        presenter.setUpInitialSettings(toolbar);

        // Bindeo del botón "Nueva medición"
        Button nuevaMedicion = (Button) vista.findViewById(R.id.nueva_medicion);
        nuevaMedicion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                presenter.onNuevaMedicionClicked();
            }
        });

        // Bindeo del botón "Últimas 10 mediciones"
        Button ultimasMediciones = (Button) vista.findViewById(R.id.ultimas_mediciones);
        ultimasMediciones.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                presenter.onUltimasMedicionesClicked();
            }
        });

        // Bindeo del botón "Perfiles de pacientes"
        Button pacientes = (Button) vista.findViewById(R.id.pacientes);
        pacientes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                presenter.onPerfilPacientesClicked();
            }
        });
        return vista;
    }

    /**
     * Perform any final cleanup before an activity is destroyed.
     */
    @Override
    public void onDestroy() {
        presenter.onDestroy();
        super.onDestroy();
    }
}
