package com.uva.rafael.tfg_goniometer.view.fragments;

import android.app.Fragment;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.uva.rafael.tfg_goniometer.R;
import com.uva.rafael.tfg_goniometer.dependencyInjection.App;
import com.uva.rafael.tfg_goniometer.interfaces.ViewFunctions;
import com.uva.rafael.tfg_goniometer.presenter.SobreAppPresenter;

import javax.inject.Inject;

/**
 * Esta clase es el <tt>Fragment</tt> que muestra información sobre la aplicación (versión de la
 * misma, qué funciones tiene, así como quién la ha desarrollado), que se ejecuta en el momento en
 * que el usuario pulsa sobre la opción "Sobre TFG-Goniometer" del menú lateral de la misma.
 *
 * <p>Además, se encarga de asignar al objeto <tt>ImageView</tt> que contiene el icono de la
 * aplicación, el objeto <tt>RoundedBitmapDrawable</tt> obtenido desde <tt>SobreAppPresenter</tt>
 * con el icono en formato circular.</p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informática (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Toolbar
 * @see SobreAppPresenter
 * @version 1.0
 */

public class SobreAppFragment extends Fragment implements ViewFunctions.SobreAppFunctions {

    /*
     * Presentador asociado con este Fragment (Vista). Su instancia se obtiene mediante Inversión
     * de Dependencias
     */
    @SuppressWarnings({"unused", "CanBeFinal"})
    @Inject
    SobreAppPresenter presenter;

    // ImageView que contiene el icono de la aplicación
    private ImageView iconoApp;

    /**
     * Método llamado para instanciar el <tt>Fragment</tt> con su layout asociada
     * (R.layout.sobre_app_fragment, en este caso).
     *
     * @param inflater           The LayoutInflater object that can be used to inflate any view in the
     *                           fragment.
     * @param container          If non-null, this is the parent view that the fragment's UI should be
     *                           attached to. The fragment should not add the view itself, but this can be
     *                           used to generate the LayoutParams of the view.
     * @param savedInstanceState If non-null, this fragment is being re-constructed from a previous
     *                           saved state as given here. Return the View for the fragment's UI,
     *                           or null.
     */
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             Bundle savedInstanceState) {

        // Obtención de la instancia de HomePresenter
        ((App) getActivity().getApplication()).getComponent(this).injectSobreAppFragment(this);

        // Inflar el layout del Fragment
        View vista = inflater.inflate(R.layout.sobre_app_fragment, container, false);

        // Bindeo del Toolbar
        Toolbar toolbar = (Toolbar) vista.findViewById(R.id.toolbar);

        // Bindeo de la imagen de la App
        iconoApp = (ImageView) vista.findViewById(R.id.imagenApp);

        // Configuración inicial
        presenter.setUpInitialSettings(toolbar);

        return vista;
    }

    /**
     * Método que se encarga de asignar al objeto <tt>ImageView</tt> que contiene el icono de la
     * aplicación, el objeto <tt>RoundedBitmapDrawable</tt> con el icono una vez se ha transformado
     * para que esté contenido en un círculo (en vez de mantener la forma rectangular original).
     *
     * @param drawable Objeto <tt>RoundedBitmapDrawable</tt> con el icono transformado
     */
    @Override
    public void setImageDrawable(RoundedBitmapDrawable drawable) {
        // Set the ImageView image as drawable object
        iconoApp.setImageDrawable(drawable);
    }

    /**
     * Perform any final cleanup before an activity is destroyed.
     */
    @Override
    public void onDestroy() {
        presenter.onDestroy();
        super.onDestroy();
    }
}
