package com.uva.rafael.tfg_goniometer.dependencyInjection;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;

/**
 * Esta clase (que hereda de <tt>Application</tt>) es la encargada de instanciar los Componentes
 * (según la terminología de la biblioteca Dagger 2), es decir, se encarga de indicar cómo se
 * relacionan los Módulos y los Componentes dentro de la aplicación.
 *
 * <p>Dado que, en este caso, el Módulo tiene dos constructores distintos (uno para
 * <tt>MainActivity</tt> y otro para <tt>Fragment</tt>), esta clase también dispone de dos
 * métodos para la instanciación del Componente, en función del objeto que se reciba como parámetro.</p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see Component
 * @see Module
 * @version 1.0
 */

public class App extends Application {

    /**
     * Método para instanciar el Componente utilizando el constructor del Módulo que recibe una
     * referencia a <tt>MainActivity</tt> como parámetro.
     *
     * @param activity Referencia a <tt>MainActivity</tt> para la construcción del Módulo
     * @return component Instancia de <tt>Component</tt>
     */
    public Component getComponent(Activity activity) {
        return DaggerComponent.builder().module(new Module(activity)).build();
    }

    /**
     * Método para instanciar el Componente utilizando el constructor del Módulo que recibe una
     * referencia a <tt>Fragment</tt> como parámetro.
     *
     * @param fragment Referencia a <tt>Fragment</tt> para la construcción del Módulo
     * @return component Instancia de <tt>Component</tt>
     */
    public Component getComponent(Fragment fragment) {
        return DaggerComponent.builder().module(new Module(fragment)).build();
    }
}
