package com.uva.rafael.tfg_goniometer.data;

/**
 * Esta clase representa el esquema de la Base de Datos relacional. Define una serie de constantes
 * que son utilizadas como nombres para las columnas de cada una de las tablas de la Base de Datos.
 *
 * <p>Como dato a añadir, cada una de las sub-clases que componen esta clase representa una de las
 * tablas de la Base de Datos.</p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @version 1.0
 */

public class Contract {
    /**
     * Tabla PACIENTE
     */
    public static abstract class PatientEntry {
        public static final String TABLE_NAME = "paciente";

        public static final String NOMBRE = "nombre";
        public static final String EDAD = "edad";
        public static final String SEXO = "sexo";
        public static final String ID = "id";
        public static final String DIAGNOSTICO = "diagnostico";
        public static final String TAGS = "tags";

        public static final String TELEFONO = "telefono";
        public static final String DIRECCION = "direccion";
        public static final String SINTOMAS = "sintomas";
        public static final String TRATAMIENTO_PREVIO = "tratamiento_previo";
        public static final String TRATAMIENTO_ACTUAL = "tratamiento_actual";
        public static final String COMENTARIOS = "comentarios";
    }

    /**
     * Tabla MEDICION
     */
    public static abstract class MeasurementEntry {
        public static final String TABLE_NAME = "medicion";

        public static final String FECHA_HORA = "fecha_hora";
        public static final String LECTURA = "lectura";
        public static final String LADO = "lado";
        public static final String ARTICULACION = "articulacion";
        public static final String OTRA_ARTICULACION = "otra_articulacion";
        public static final String MOVIMIENTO = "movimiento";
        public static final String OTRO_MOVIMIENTO = "otro_movimiento";
        public static final String MODO = "modo";
        public static final String OTRO_MODO = "otro_modo";
        public static final String NOMBRE_PACIENTE = "nombre_paciente";
        public static final String ID_PACIENTE = "id_paciente";
    }

    /**
     * Tabla de tipo <tt>Enum</tt> - ARTICULACION
     */
    static abstract class JointEnum {
        static final String TABLE_NAME = "jointEnum";

        static final String ARTICULACION = "articulacion";
        static final String OTRA_ARTICULACION = "otra_articulacion";
    }

    /**
     * Tabla de tipo <tt>Enum</tt> - LADO
     */
    static abstract class SideEnum {
        static final String TABLE_NAME = "sideEnum";

        static final String LADO = "lado";
    }

    /**
     * Tabla de tipo <tt>Enum</tt> - MODO
     */
    static abstract class ModeEnum {
        static final String TABLE_NAME = "modeEnum";

        static final String MODO = "modo";
        static final String OTRO_MODO = "otro_modo";
    }

    /**
     * Tabla de tipo <tt>Enum</tt> - SEXO
     */
    static abstract class SexEnum {
        static final String TABLE_NAME = "sexEnum";

        static final String SEXO = "sexo";
    }

    /**
     * Tabla de tipo <tt>Enum</tt> - TIPOMOVIMIENTO
     */
    static abstract class MovementTypeEnum {
        static final String TABLE_NAME = "movementTypeEnum";

        static final String TIPO_MOVIMIENTO = "tipo_movimiento";
        static final String OTRO_TIPO_MOVIMIENTO = "otro_tipo_movimiento";
    }
}
