package com.uva.rafael.tfg_goniometer.data.entities;

import android.content.ContentValues;

import com.uva.rafael.tfg_goniometer.data.enums.Modo;
import com.uva.rafael.tfg_goniometer.data.enums.TipoMovimiento;

/**
 * Esta clase modela a la <tt>Entity</tt> "Movimiento" de la Base de Datos.
 *
 * <p>Se encarga de proveer un método para insertar un "Movimiento" en la Base de Datos, pasando
 * cada uno de los atributos que componen esta clase a un formato adecuado, por medio de un objeto
 * de tipo <tt>ContentValues</tt>.</p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see TipoMovimiento
 * @see Modo
 * @see ContentValues
 * @version 1.0
 */

public class Movimiento {
    // Movimiento en sí realizado por la articulación
    private final TipoMovimiento tipoMovimiento;
    // Modo en el que se realizó el movimiento (con ayuda, sin ayuda...)
    private final Modo modo;

    /**
     * Constructor principal de la clase
     *
     * @param tipoMovimiento Movimiento en sí realizado por la articulación
     * @param modo           Modo en el que se realizó el movimiento (con ayuda, sin ayuda...)
     */
    public Movimiento(TipoMovimiento tipoMovimiento, Modo modo) {
        this.tipoMovimiento = tipoMovimiento;
        this.modo = modo;
    }

    /*
     * Método que se encarga de dar un formato adecuado a cada uno de los atributos de la clase,
     * para, posteriormente, ser insertados en la Base de Datos.
     *
     * En concreto, recibe una referencia al objeto ContentValues pasado desde la Entity "Medicion"
     * y, simplemente, se encarga de añadir los campos TipoMovimiento y Modo
     */
    void toContentValues(ContentValues values) {
        /*
         * Para la obtención del ContentValues, se utiliza el método "toContentValues" de las clases
         * correspondientes
         */
        tipoMovimiento.toContentValues(values);
        modo.toContentValues(values);
    }
}
