package com.uva.rafael.tfg_goniometer.interfaces;

import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.animation.Animation;

import java.util.ArrayList;

/**
 * Esta interfaz engloba métodos públicos de algunas de las clases de tipo <tt>View</tt> (en el
 * sentido de "Model-View-Presenter", no en el sentido de <tt>View</tt> que tiene Android) que se
 * encuentran en el paquete "view.fragments" de esta aplicación.
 *
 * <p>Esta interfaz posee dos métodos que utilizan varios de los <tt>Fragments</tt>, razón por la
 * cual son métodos comunes a toda la interfaz. Ademas de esto, varios de los <tt>Fragment</tt>
 * poseen su propia interfaz, que engloba los métodos específicos de cada uno de ellos.</p>
 *
 * <p>Esta interfaz forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informatica (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see AlertDialog
 * @see Animation
 * @version 1.0
 */
@SuppressWarnings("unused")
public interface ViewFunctions {

    /**
     * Método que muestra un mensaje de éxito cuando se ha logrado insertar o eliminar un dato
     * correctamente de la Base de Datos.
     */
    void displaySuccess();

    /**
     * Método que muestra un mensaje de error cuando se ha intentado insertar o eliminar un dato de
     * la Base de Datos.
     */
    void displayError();

    /**
     * Interfaz correspondiente al <tt>Fragment MedicionFragment</tt>
     */
    interface MedicionFunctions {

        /**
         * Método que simplemente muestra el <tt>AlertDialog</tt> que ha recibido como parámetro.
         *
         * @param dialog <tt>AlertDialog</tt> a mostrar
         */
        void displayResult(AlertDialog dialog);

        /**
         * Método "setter" del parámetro <tt>lecturaGoniometro</tt> de tipo <tt>TextView</tt>.
         *
         * @param lectura Cadena de texto a mostrar en el <tt>TextView</tt>
         */
        void setLecturaGoniometroText(String lectura);

        /**
         * Método que inicia la animación sobre la <tt>View</tt> que refleja graficamente el
         * desplazamiento del dispositivo.
         *
         * @param animation <tt>Animation</tt> que se asignara al parámetro <tt>desplazamiento</tt>.
         */
        void startAnimation(Animation animation);

        /**
         * Método que se encarga de fijar el tamaño del goniómetro en función del ancho de la
         * pantalla del dispositivo.
         *
         * @param tamañoGoniometro Tamaño final del goniómetro
         */
        void setTamañoGoniometro(int tamañoGoniometro);

        /**
         * Método que se encarga de fijar el tamaño del botón "Reiniciar" en función del ancho de la
         * pantalla del dispositivo.
         *
         * @param tamañoReiniciar Tamaño final del botón "Reiniciar"
         */
        void setTamañoReiniciar(int tamañoReiniciar);
    }

    /**
     * Interfaz correspondiente al <tt>Fragment NuevaMedicionFragment</tt>
     */
    interface NuevaMedicionFunctions {

        /**
         * Método que se encarga de asignar a las variables locales, la información contenida en el
         * <tt>Bundle</tt>
         *
         * @param constantesBundle <tt>ArrayList<String></tt> con las constantes para obtener la
         *                         información del <tt>Bundle</tt>
         */
        void setConstantesBundle(ArrayList<String> constantesBundle);

        /**
         * Método que se encarga de escribir en el <tt>TextView</tt> indicado el texto que recibe
         * como parámetro.
         *
         * @param textView <tt>TextView</tt> en el que se debe escribir
         * @param text     Texto a escribir
         */
        void setText(int textView, String text);

        /**
         * Método que se encarga de modificar la visibilidad del <tt>LinearLayout</tt> en función
         * del segundo parámetro que se recibe
         *
         * @param layout <tt>LinearLayout</tt> sobre el que se aplica este método
         * @param visible Visibilidad a asignar
         */
        void setLayoutVisibility(int layout, int visible);

        /**
         * Método que muestra un mensaje de éxito cuando se ha logrado almacenar correctamente una
         * medición en la Base de Datos.
         */
        void displaySuccess();

        /**
         * Método que muestra un mensaje de error cuando se ha intentado introducir una nueva
         * medición en la Base de Datos.
         */
        void displayErrorDatabase();

        /**
         * Método que muestra un mensaje de error cuando el usuario ha introducido algún dato
         * erróneo, o no ha rellenado alguno de los campos obligatorios al almacenar una nueva
         * medición.
         */
        void displayErrorUser();
    }

    /**
     * Interfaz correspondiente al <tt>Fragment NuevoPacienteFragment</tt>
     */
    interface NuevoPacienteFunctions {

        /**
         * Método que muestra un mensaje de éxito cuando se ha logrado almacenar correctamente un
         * paciente en la Base de Datos.
         */
        void displaySuccess();

        /**
         * Método que muestra un mensaje de error cuando se ha intentado introducir un nuevo
         * paciente en la Base de Datos.
         */
        void displayErrorDatabase();

        /**
         * Método que muestra un mensaje de error cuando el usuario ha introducido algún dato
         * erróneo, o no ha rellenado alguno de los campos obligatorios al almacenar un nuevo
         * paciente.
         */
        void displayErrorUser();

        /**
         * Método que muestra un mensaje de error cuando el usuario ha intentado introducir un paciente
         * con el mismo nombre e ID que uno ya existente en la Base de Datos.
         */
        void displayErrorExistingPatient();
    }

    /**
     * Interfaz correspondiente al <tt>Fragment PerfilPacienteFragment</tt>
     */
    interface PerfilPacienteFunctions {

        /**
         * Método que se encarga de asignar a las variables locales, la información contenida en el
         * <tt>Bundle</tt>
         *
         * @param constantesBundle <tt>ArrayList<String></tt> con las constantes para obtener la
         *                         información del <tt>Bundle</tt>
         */
        void setConstantesBundle(ArrayList<String> constantesBundle);

        /**
         * Método que se encarga de escribir en el <tt>TextView</tt> indicado el texto que recibe
         * como parámetro.
         *
         * @param textView <tt>TextView</tt> en el que se debe escribir
         * @param text Texto a escribir
         */
        void setText(int textView, String text);

        /**
         * Método que se encarga de añadir una <tt>View</tt> hija al <tt>Table Layout</tt> que
         * contiene el listado de mediciones del paciente
         *
         * @param view <tt>View</tt> hija a añadir
         */
        void addView(View view);

        /**
         * Método que simplemente muestra el <tt>AlertDialog</tt> que ha recibido como parámetro.
         *
         * @param dialog <tt>AlertDialog</tt> a mostrar
         */
        void displayResult(AlertDialog dialog);
    }

    /**
     * Interfaz correspondiente al <tt>Fragment UltimasMedicionesFragment</tt>
     */
    interface UltimasMedicionesFunctions {

        /**
         * Método que simplemente muestra el <tt>AlertDialog</tt> que ha recibido como parámetro.
         *
         * @param dialog <tt>AlertDialog</tt> a mostrar
         */
        void displayResult(AlertDialog dialog);

        /**
         * Método que se encarga de re-asignar el <tt>RecyclerView.Adapter</tt>
         * (<tt>MedicionListAdapter</tt>, en este caso) al <tt>RecyclerView</tt> del
         * <tt>Fragment</tt>.
         *
         * @param adapter <tt>RecyclerView.Adapter</tt> a asignar
         */
        void setAdapter(RecyclerView.Adapter adapter);
    }

    /**
     * Interfaz correspondiente al <tt>Fragment SobreAppFragment</tt>
     */
    interface SobreAppFunctions {

        /**
         * Método que se encarga de asignar al objeto <tt>ImageView</tt> que contiene el icono de la
         * aplicación, el objeto <tt>RoundedBitmapDrawable</tt> con el icono una vez se ha
         * transformado para que esté contenido en un círculo (en vez de mantener la forma
         * rectangular original).
         *
         * @param drawable Objeto <tt>RoundedBitmapDrawable</tt> con el icono transformado
         */
        void setImageDrawable(RoundedBitmapDrawable drawable);
    }
}
