package com.uva.rafael.tfg_goniometer.view;

import android.os.Bundle;
import android.support.design.widget.NavigationView;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;

import com.uva.rafael.tfg_goniometer.R;
import com.uva.rafael.tfg_goniometer.dependencyInjection.App;
import com.uva.rafael.tfg_goniometer.presenter.MainPresenter;

import javax.inject.Inject;

/**
 * Esta clase es la única y principal <tt>Activity</tt> de la aplicación.
 *
 * <p>Se encarga básicamente de inflar el layout principal de la aplicación (<tt>activity_main</tt>),
 * que servirá como contenedor de todos los <tt>Fragment</tt> que forman la aplicación.</p>
 *
 * <p>Además se encarga de comunicar a <tt>MainPresenter</tt> cuando sucede algún cambio en el
 * <tt>NavigationView</tt> </p>
 *
 * <p>Esta clase forma parte de la aplicación TFG-Goniometer, desarrollada para el Trabajo de
 * Fin de Grado - Grado en Ingeniería Informática (Universidad de Valladolid)</p>
 *
 * @author Rafael Matamoros Luque
 * @see DrawerLayout
 * @see NavigationView
 * @see MainPresenter
 * @see AppCompatActivity
 * @version 1.0
 */
public class MainActivity extends AppCompatActivity {

    /*
     * Presentador asociado con la actividad principal de la aplicación.
     * Su instancia se obtiene mediante Inversión de Dependencias
     */
    @SuppressWarnings({"unused", "CanBeFinal"})
    @Inject
    MainPresenter presenter;

    /*
     * Called when the activity is starting.
     *
     * @param savedInstanceState <tt>Bundle</tt>: If the activity is being re-initialized after
     *                           previously being shut down then this <tt>Bundle</tt> contains the
     *                           data it most recently supplied in
     *                           <tt>onSaveInstanceState(Bundle)</tt>. Otherwise it is null.
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Obtención de la instancia de MainPresenter
        ((App) getApplication()).getComponent(this).injectMainActivity(this);

        // Creación e inicialización del Fragment HomeFragment inicial y obtención
        // de la clase SQLiteHelper que se empleará para el manejo de la BD
        presenter.setUpInitialSettings();

        // "Bindeo" de los elementos de la IU para pasar su referencia a MainPresenter
        DrawerLayout drawerLayout = (DrawerLayout) findViewById(R.id.drawerLayout);
        NavigationView navigationView = (NavigationView) findViewById(R.id.navigationView);

        presenter.setNavigationItemSelectedListener(navigationView, drawerLayout);
    }

    /**
     * Initialize the contents of the Activity's standard options menu.
     *
     * @param menu The options menu in which we place our items.
     * @return true for the menu to be displayed; if you return false it will not be shown.
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        presenter.onCreateOptionsMenu(menu);
        return true;
    }

    /**
     * Prepare the Screen's standard options menu to be displayed
     *
     * @param menu The options menu as last shown or first initialized by onCreateOptionsMenu().
     * @return true for the menu to be displayed; if you return false it will not be shown.
     */
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        presenter.onPrepareOptionsMenu(menu);
        return super.onPrepareOptionsMenu(menu);
    }

    /**
     * This hook is called whenever an item in your options menu is selected.
     *
     * @param item The menu item that was selected.
     * @return Return false to allow normal menu processing to proceed, true to consume it here.
     */
    public boolean onOptionsItemSelected(MenuItem item) {
        return presenter.onOptionsItemSelected(item) || super.onOptionsItemSelected(item);
    }

    /**
     * Called when the activity has detected the user's press of the back key.
     */
    @Override
    public void onBackPressed() {
        presenter.onBackPressed();
        super.onBackPressed();
    }

    /**
     * Método que se emplea para marcar como seleccionado uno de los distintos items en el
     * <tt>NavigationView</tt>.
     *
     * @param code Posición del item a marcar dentro del <tt>NavigationView</tt>
     */
    public void setNavigationItem(int code) {
        presenter.setNavigationItem(code);
    }

    /*
     * Perform any final cleanup before an activity is destroyed.
     */
    @Override
    protected void onDestroy() {
        presenter.onDestroy();
        super.onDestroy();
    }
}
