/*
TRABAJO FIN DE GRADO 1335
DESARROLLO DE UN SISTEMA DE MEDIDA DEL DIMETRO PUPILAR DE ALTA RESPUESTA EN FRECUENCIA Y PARA ESCENARIOS DE BAJA ILUMINACIN
AUTOR: Pablo Rosales Rodrguez, con DNI 12420233A
TUTOR: Alberto Mansilla Gallo

Valladolid, junio de 2019
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SOFTWARE DE PROCESAMIENTO SEMIAUTOMTICO
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include <iostream>
#include <opencv2/opencv.hpp>
#include "operaciones_imagen.h"
#include "problema_circulos.h"
#include <fstream>
#include <string>
#include <vector>
#include <cmath>


using namespace cv;
using namespace std;

int main()
{		
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//VARIABLES A DETERMINAR POR EL USUARIO
	//PRIMERA IMAGEN
	int img_counter =0;
	//LTIMA IMAGEN
	int numero_imagenes = 35;

	//CONSTANTES DE CALIBRACIN
	//Umbrales canny y binarizacin
	int cte_binarizar = 40;
	int cte_canny = 50;
	int cte_canny_roi = 20;
	//Dilatacin
	int cte_dilate = 12;
	//Altura de la ROI
	float altura_roi = 300;
	float mitad_roi = 200;
	//Radios T. HOUGH inicial
	int radio_min = 20;
	int radio_max = 90;
	int cte_hough = 13;
	//Radios T.HOUGH final
	int radio_min_2 = radio_min;
	int radio_max_2 = 100;
	int cte_hough_2 = cte_hough;

	//BUCLE FOR DE BSQUEDA DE PUNTOS
	//Filas:
	int limite_ver_inf = 70;
	int limite_ver_sup = 70;
	int paso_ver = 10;
	//Columnas:
	int limite_hor_inf = 100;
	int limite_hor_sup = 100;
	int paso_hor = 10;

	//Constante: margen hasta para que el pxel pertenezca al borde
	//4
	int margen_borde = 5;

	//PONER A TRUE SI SOLO SE DESEA CUBRIR LA MITAD INFERIOR
	bool solo_mitad_inferior = false;
	bool testigo_mitad_superior = solo_mitad_inferior;
	
	//CORRECCION CON HOUGH
	bool correccion = true;
	double error_correccion = 0.01;

	//MEDIA VALORES
	int valores_media = 4;

	//HORIZONTAL DE LOS OJOS
	int margen_hor= 100;


	//RUTAS DE CARPETAS
	//Ruta a la carpeta de imgenes
	string ruta_input = "C://Dev//Proyecto//Pupilometrias//output//3D//6//ir//uno//img_";
	//Ruta a la carpeta de salida de imgenes
	string ruta_output = "C://Dev//Proyecto//Pupilometrias//procesado//3D//6//cuatro//img_";

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//Rutas inicializacin
	string png_img = ".png";

	//INICIALIZACIN DE VARIABLES NECESARIAS PARA EL PROGRAMA
	vector <float> vector_radios;
	float radio_anterior = 0;
	float media_10 = 0;
	float relacion;
	int contador_ojos = 0;


	//FICHEROS DE LECTURA Y ESCRITURA
	ifstream fs_input;
	fs_input.open("relacion.txt", ios::out);
	fs_input >> relacion;
	fs_input.close();

	ofstream fs("pupilas.txt");
	fs << relacion << endl;

	ofstream xs("pupilas_x.csv");
	xs << "PUPILOMETRIA CON RELACIN" << ": " << relacion << endl;
	xs << "IMAGEN: OJO 1: OJO 2: DIMETRO 1: DIMETRO 2: LUXES" << endl;

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//BUCLE DE PROCESAMIENTO DE IMGENES
	bool bucle = true;
	while (bucle)
	{
		//PONER A TRUE SI SOLO SE DESEA CUBRIR LA MITAD INFERIOR
		testigo_mitad_superior = solo_mitad_inferior;

		++img_counter;
		cout << endl << "FOTOGRAMA " << img_counter << endl;
		string ruta_entrada = ruta_input + to_string(img_counter) + png_img;
		Mat imagen_opencv = imread(ruta_entrada, CV_LOAD_IMAGE_COLOR);


		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//RECORTA IMAGEN
		int width = imagen_opencv.cols-800;
		int height = imagen_opencv.rows-1000;
		Rect recorta(0, 0, width, height);
		//imagen_opencv = imagen_opencv(recorta);
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		//SEGMENTACIN
		Mat imagen_binarizada, imagen_canny, imagen_binarizada_roi, imagen_canny_roi, imagen_opencv_roi;
		img::operaciones_imagen operaciones(imagen_opencv);

		imagen_binarizada = operaciones.binarize_function(imagen_opencv, cte_binarizar);
		imagen_canny = operaciones.canny_function(imagen_opencv, cte_canny);

		//BSQUEDA DE CRCULOS EN LA IMAGEN DE PARTIDA: HOUGH
		vector <Vec3f> circulos_inicial;
		cvtColor(imagen_binarizada, imagen_binarizada, COLOR_RGB2GRAY);
		
		//Muestra imagen binarizada
		namedWindow("Imagen Binarizada", WINDOW_NORMAL);
		imshow("Imagen Binarizada", imagen_binarizada);

		//Muestra imagen canny
		/*namedWindow("Imagen Canny", WINDOW_NORMAL);
		imshow("Imagen Canny", imagen_canny);*/

		//Transformada de hough para buscar crculos
		HoughCircles(imagen_binarizada, circulos_inicial, CV_HOUGH_GRADIENT, 1, imagen_binarizada.rows / 4, cte_canny, cte_hough, radio_min, radio_max);
		cout << "Circulos encontrados inicialmente: " << circulos_inicial.size() << endl;

		//Imprime en la imagen de partida los crculos encontrados
		for (unsigned int i = 0; i != circulos_inicial.size(); i++)
		{
			Point center(cvRound(circulos_inicial[i][0]), cvRound(circulos_inicial[i][1]));
			int radius = cvRound(circulos_inicial[i][2]);
			//circle(imagen_opencv, center, 3, Scalar(255, 0, 0), -1, 8, 0);
			circle(imagen_opencv, center, radius, Scalar(255, 0, 0), 3, 8, 0);
		}



		//Muestra de nuevo la imagen de partida con los crculos impresos
		namedWindow("Imagen de partida", WINDOW_NORMAL);
		imshow("Imagen de partida", imagen_opencv);

		//Comprueba si se tienen dos crculos en la misma horizontal
		for (unsigned int i = 0; i != circulos_inicial.size(); i++)
		{
			if (i < circulos_inicial.size() - 1)
			{
				if (circulos_inicial[i][1] < (circulos_inicial[i + 1][1] + margen_hor) || circulos_inicial[i][1] > (circulos_inicial[i + 1][1] - margen_hor))
				{
					mitad_roi = circulos_inicial[i][1];
				}
			}
		}
		//Dibuja una lnea en la horizontal de los crculos
		//line(imagen_opencv, Point(0, cvRound(mitad_roi)), Point(cvRound(imagen_opencv.cols), cvRound(mitad_roi)), Scalar(255, 0, 0), 10, 8);
		/*namedWindow("Imagen de partida", WINDOW_NORMAL);
		imshow("Imagen de partida", imagen_opencv);*/

		//EXTRACCIN DE LA REGIN DE INTERS: ROI
		Rect roi(0, (mitad_roi - (altura_roi / 2)), imagen_opencv.cols, altura_roi);
		imagen_opencv_roi = imagen_opencv(roi);
		cvtColor(imagen_opencv_roi, imagen_opencv_roi, COLOR_RGB2GRAY);
		//SEGMENTACIN DE LA IMAGEN ROI
		imagen_canny_roi = operaciones.canny_function(imagen_opencv_roi, cte_canny_roi);
		imagen_binarizada_roi = operaciones.binarize_function(imagen_opencv_roi, cte_binarizar);


		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//MUESTRA DE IMGENES DE TAMAO ROI
		/*
		namedWindow("Imagen ROI", WINDOW_NORMAL);
		imshow("Imagen ROI", imagen_opencv_roi);

		namedWindow("Imagen Canny ROI", WINDOW_NORMAL);
		imshow("Imagen Canny ROI", imagen_canny_roi);

		namedWindow("Imagen Binarizada ROI", WINDOW_NORMAL);
		imshow("Imagen Binarizada ROI", imagen_binarizada_roi);
		*/
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		//DILATACIN PARA ELIMINAR HUECOS DE LA PUPILA
		Mat element = getStructuringElement(MORPH_ELLIPSE, Size(cte_dilate, cte_dilate), Point(0, 0));
		dilate(imagen_binarizada_roi, imagen_binarizada_roi, element);
		namedWindow("Imagen Binarizada ROI", WINDOW_NORMAL);
		imshow("Imagen Binarizada ROI", imagen_binarizada_roi);

		//Aplica CANNY a la imagen binarizada ROI
		/*imagen_binarizada_roi = operaciones.canny_function(imagen_binarizada_roi, cte_canny_roi);
		namedWindow("imagen_binarizada_roi", WINDOW_NORMAL);
		imshow("imagen_binarizada_roi", imagen_binarizada_roi);*/

		//BSQUEDA DE CRCULOS EN LA IMAGEN ROI: HOUGH
		vector<Vec3f> circulos_roi;
		HoughCircles(imagen_binarizada_roi, circulos_roi, CV_HOUGH_GRADIENT, 1, imagen_binarizada_roi.rows / 8, cte_canny_roi, cte_hough_2, radio_min_2, radio_max_2);
		cvtColor(imagen_opencv_roi, imagen_opencv_roi, COLOR_GRAY2RGB);

		//Imprime los crculos encontrados
		/*
		for (unsigned int i = 0; i != circulos_roi.size(); i++)
		{
			Point center(cvRound(circulos_roi[i][0]), cvRound(circulos_roi[i][1]));
			int radius = cvRound(circulos_roi[i][2]);
			circle(imagen_opencv_roi, center, 3, Scalar(0, 255, 0), -1, 8, 0);
			circle(imagen_opencv_roi, center, radius, Scalar(0, 0, 255), 3, 8, 0);
		}
		namedWindow("imagen_opencv_roi", WINDOW_NORMAL);
		imshow("imagen_opencv_roi", imagen_opencv_roi);
		*/
		cout << "Circulos encontrados en la ROI: " << circulos_inicial.size() << endl;

		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//ALGORITMO DE MEDIDA DEL DIMETRO PUPILAR
		bool fin = false;
		unsigned char intensity;
		int vec_it = 0;

		//Cada posicion del vector hace referencia a un circulo existente y en cada una almacena otro vector con los tres puntos 
		//asociados al mencionado circulo
		vector <vector <Point>> vector_circulos;
		vector <Point> auxiliar(3);

		Mat imagen_binarizada_color(imagen_binarizada_roi);
		cvtColor(imagen_binarizada_color, imagen_binarizada_color, COLOR_GRAY2RGB);
		double valor_y = 0;
		double valor_x = 0;
		for (unsigned int k = 0; k != circulos_roi.size(); k++)
		{
			valor_y = 0;
			Point center(cvRound(circulos_roi[k][0]), cvRound(circulos_roi[k][1]));

			while (vec_it < 3)
			{
				
				for (unsigned int l = (center.y - limite_ver_inf); l != (center.y+limite_ver_sup); l += paso_ver) //l=y=filas
				{
					for (unsigned int u = (center.x - limite_hor_inf); u != (center.x + limite_hor_sup); u += paso_hor) //u=x=columnas
					{
						intensity = imagen_binarizada_roi.at<uchar>(l, u);
						circle(imagen_binarizada_color, Point(u, l), 2, Scalar(0, 0, 255), -1, 8, 0);
						if (vec_it < 3)
						{
							if (intensity == 255)
							{
								circle(imagen_binarizada_color, Point(u, l), 2, Scalar(0, 255, 0), -1, 8, 0);
								//MITAD INFERIOR
								//Mitad inferior izquierda
								if (l > center.y && u < center.x && l!=valor_x)
								{
									if (imagen_binarizada_roi.at<uchar>(l, u - margen_borde) != 255)
									{
										auxiliar.at(vec_it).x = u;
										auxiliar.at(vec_it).y = l;
										++vec_it;
										circle(imagen_binarizada_color, Point(u, l), 5, Scalar(255, 0, 0), -1, 8, 0);
									}
								}
								//Mitad inferior derecha
								else if (l > center.y && u > center.x && l!=valor_x)
								{
									if (imagen_binarizada_roi.at<uchar>(l, u + margen_borde) != 255)
									{
										auxiliar.at(vec_it).x = u;
										auxiliar.at(vec_it).y = l;
										++vec_it;
										circle(imagen_binarizada_color, Point(u, l), 5, Scalar(255, 0, 0), -1, 8, 0);
									}
								}
								//MITAD SUPERIOR
								//Mitad superior izquierda
								else if (l < center.y && u < center.x && testigo_mitad_superior==false && l!=valor_x)
								{
									if (imagen_binarizada_roi.at<uchar>(l, u - margen_borde) != 255)
									{
										auxiliar.at(vec_it).x = u;
										auxiliar.at(vec_it).y = l;
										++vec_it;
										circle(imagen_binarizada_color, Point(u, l), 5, Scalar(255, 0, 0), -1, 8, 0);
										testigo_mitad_superior = true;
									}
								}
								//Mitad superior derecha
								else if (l< center.y && u> center.x && testigo_mitad_superior == false && l!=valor_x)
								{
									if (imagen_binarizada_roi.at<uchar>(l, u + margen_borde) != 255)
									{
										auxiliar.at(vec_it).x = u;
										auxiliar.at(vec_it).y = l;
										++vec_it;
										circle(imagen_binarizada_color, Point(u, l), 5, Scalar(255, 0, 0), -1, 8, 0);
										testigo_mitad_superior = true;
									}
								}
							}
						}
					}
				}
			}

			vector_circulos.push_back(auxiliar);
			valor_y = auxiliar.at(k).y;
			valor_x = auxiliar.at(k).x;
			vec_it = 0;
		}

	

		namedWindow("Imagen Binarizada en color", WINDOW_NORMAL);
		imshow("Imagen Binarizada en color", imagen_binarizada_color);

		//Variables impresin de crculos
		int aviso = 0;
		bool testigo_correccion = false;

		bool testigo_sustituye = false;
		for (unsigned int i = 0; i != vector_circulos.size(); i++)
		{
			aviso = 0;
			for (unsigned int j = 0; j != 3; j++)
			{
				circle(imagen_opencv_roi, Point(vector_circulos.at(i).at(j).x, vector_circulos.at(i).at(j).y), 3, Scalar(255, 0, 0), -1, 8, 0);
			}
			Point p1, p2, p3;
			p1 = Point(vector_circulos.at(i).at(0).x, vector_circulos.at(i).at(0).y);
			p2 = Point(vector_circulos.at(i).at(1).x, vector_circulos.at(i).at(1).y);
			p3 = Point(vector_circulos.at(i).at(2).x, vector_circulos.at(i).at(2).y);

			//ALGORITMO BASADO EN DETERMINANTES: CRCULO A PARTIR DE 3 PUNTOS
			circulo::problema_circulos problema(p1, p2, p3);
			long double det_p, det_c, det_d, det_e, radius, c, d, e;
			Point center;

			det_p = problema.get_det(p1, p2, p3, 1);
			det_c = problema.get_det(p1, p2, p3, 2);
			det_d = problema.get_det(p1, p2, p3, 3);
			det_e = problema.get_det(p1, p2, p3, 4);

			//SOLUCION DEL PROBLEMA, CRCULO: radius, center
			center = problema.get_center(det_p, det_c, det_d);
			radius = problema.get_radius(det_p, det_c, det_d, det_e);
				
			//CORRECIN O SUSTITUCIN
			if (correccion == true || radius != radius)
			{
				if (circulos_inicial.size() >= 2 && abs((radius - circulos_roi[i][2]) / circulos_roi[i][2]) > error_correccion || circulos_roi.size() >= 2 && radius !=radius)
				{
					testigo_correccion = true;
					cout << "CORRECCION" << endl;
					fs << "CORRECCION" << endl;
					radius = circulos_roi[i][2];
					center.x = circulos_roi[i][0];
					center.y = circulos_roi[i][1];
					aviso = 1;
				}
			}
			/*if (radio_anterior != 0 && abs((radius - radio_anterior) / radio_anterior) > 0.15 && aviso == 0)
			{
				testigo_sustituye = true;
				cout << "SUSTITUYE" << endl;
				fs << "SUSTITUYE" << endl;
				radius = radio_anterior;
			}
			*/

			//Se hace la media con los 5 ltimos valores del vector
			if (contador_ojos > valores_media)
			{
				media_10 = 0;
				float sumatorio_10 = 0;
				for (unsigned int i = vector_radios.size() - 1; i != vector_radios.size() - (valores_media + 1); i--)
				{
					if (vector_radios.at(i) != NULL)
						sumatorio_10 = sumatorio_10 + vector_radios.at(i);
				}
				media_10 = sumatorio_10 / valores_media;
				cout << "MEDIA VALORES = " << media_10 << endl;
			}
			else
				media_10 = 0;
			/*
			if ((contador_ojos > 12 && ((radius - media_10) / media_10) > 0.2 && vector_radios.size() > 12) && testigo_correccion == false && testigo_sustituye == false)
			{
				cout << "MEDIA 10" << endl;
				radius = media_10;
			}*/

			vector_radios.push_back(radius);

			cout << "El centro del circulo es: (" << float(center.x) << ", " << float(center.y) << ")" << endl;
			cout << "Su radio es: " << float(radius) << endl;
			fs << "OJO " << i + 1 << ": " << endl;
			fs << "Radio = " << relacion * radius << endl;
			fs << "Centro = (" << float(center.x) << ", " << float(center.y) << ")" << endl;
			contador_ojos = contador_ojos + 1;

			if (i == 1)
			{
				xs << img_counter << ": " << radio_anterior * relacion << ": " << radius * relacion << ": " << 2 * radio_anterior*relacion << ": " << 2 * radius*relacion << ": " << media_10 << endl;
			}
			radio_anterior = radius;
			if (radius > 0 && center.x > 0 && center.y > 0)
			{
				circle(imagen_opencv_roi, center, radius, Scalar(0, 255, 0), 3, 8, 0);
			}
		}
		
		
		//Muestra imagen final
		namedWindow("Imagen Final", WINDOW_NORMAL);
		imshow("Imagen Final", imagen_opencv_roi);

		//Guardado imgenes
		//GUARDA LA IMAGEN DE CALIBRACIN DE DISTANCIA
		vector<int> parametros_guardado;
		parametros_guardado.push_back(CV_IMWRITE_PNG_COMPRESSION);
		parametros_guardado.push_back(0);
		string ruta_salida = ruta_output + to_string(img_counter) + png_img;
		imwrite(ruta_salida, imagen_opencv_roi, parametros_guardado);
		

		waitKey(1);

		if (img_counter == numero_imagenes)
			bucle = false;
	}

	//Cierre de ficheros de escritura
	fs.close();
	xs.close();
	cerr << endl << "Pulse enter para salir" << endl;
	while (cin.get() != '\n');
	return 0;
}