#include "problema_circulos.h"
#include <iostream>
#include <opencv2/opencv.hpp>
#include <math.h>

using namespace cv;
using namespace std;

long double calcula_determinante(double x1, double x2, double x3, double y1, double y2, double y3, double z1, double z2, double z3)
{
	long double det;
	return det = (x1*y2*z3) + (x2*y3*z1) + (y1*x3*z2) - (x3*y2*z1) - (y3*x1*z2) - (x2*y1*z3);
}

namespace circulo
{
	long double problema_circulos::get_det(Point p1, Point p2, Point p3, int det_type)
	{
		long double det;
		double s1, s2, s3;
		s1 = -(p1.x*p1.x + p1.y*p1.y);
		s2 = -(p2.x*p2.x + p2.y*p2.y);
		s3 = -(p3.x*p3.x + p3.y*p3.y);

		switch (det_type)
		{
		case 1: //Determinante principal det_p;
			det = calcula_determinante(p1.x, p2.x, p3.x, p1.y, p2.y, p3.y, 1, 1, 1);
			break;
		case 2: //det_c
			det = calcula_determinante(s1, s2, s3, p1.y, p2.y, p3.y, 1, 1, 1);
			break;
		case 3: //det_d
			det = calcula_determinante(p1.x, p2.x, p3.x, s1, s2, s3, 1, 1, 1);
			break;
		case 4: //det_e
			det = calcula_determinante(p1.x, p2.x, p3.x, p1.y, p2.y, p3.y, s1, s2, s3);
			break;
		}
		return det;

	}

	Point problema_circulos::get_center(long double det_p, long double det_c, long double det_d)
	{
		long double c, d, a, b;
		Point center;
		c = det_c / det_p;
		d = det_d / det_p;
		a = -c / 2;
		b = -d / 2;

		center = Point(a, b);
		return center;
	}
	long double problema_circulos::get_radius(long double det_p, long double det_c, long double det_d, long double det_e)
	{
		long double c, d, e, a, b;
		long double radius;
		long double aux1, aux2, aux;
		c = det_c / det_p;
		d = det_d / det_p;
		a = -c / 2;
		b = -d / 2;
		e = det_e / det_p;
		radius = sqrt(a*a + b * b - e);
		return radius;
	}

}
