/*
TRABAJO FIN DE GRADO 1335
DESARROLLO DE UN SISTEMA DE MEDIDA DEL DIMETRO PUPILAR DE ALTA RESPUESTA EN FRECUENCIA Y PARA ESCENARIOS DE BAJA ILUMINACIN
AUTOR: Pablo Rosales Rodrguez, con DNI 12420233A
TUTOR: Alberto Mansilla Gallo

Valladolid, junio de 2019
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SOFTWARE PARA HALLAR LA PROPORCIN PXEL-MM
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include <pylon/PylonIncludes.h>
#include <pylon/PylonGUI.h>
#include <opencv2/opencv.hpp>
#include <fstream>
#include <math.h>
// Settings for using Basler USB cameras.
#include <pylon/usb/BaslerUsbInstantCamera.h>
typedef Pylon::CBaslerUsbInstantCamera Camera_t;


using namespace Basler_UsbCameraParams;
using namespace Pylon;
using namespace cv;
using namespace std;



Point punto1, punto2;
int counter = 0;




void CallBackFunc(int event, int x, int y, int flags, void* userdata)
{
	if (event == EVENT_LBUTTONDOWN)
	{
		cout << "Posicion: (" << x << ", " << y << ")" << endl;
		if (counter == 0)
		{
			punto1.x = x;
			punto1.y = y;
		}
		else if (counter == 1)
		{
			punto2.x = x;
			punto2.y = y;
		}
		counter++;
	}
}


int main()
{
	int t_expo = 12000;
	int exitCode = 0;
	int buffer_size = 1500;
	int imagenes_a_adquirir = 1;
	string ruta = "C://Dev//Proyecto//Pupilometrias//output//3D//img_calibracion_distancia.png";
	PylonInitialize();
	try
	{
		//Se crea un objeto de tipo camara: camara
		Camera_t camara(CTlFactory::GetInstance().CreateFirstDevice());
		camara.Open();
		//Se imprime la informacion de la camara
		cout << "Dispositivo: " << camara.GetDeviceInfo().GetModelName() << endl;
		//Tamao del buffer de la camara
		camara.MaxNumBuffer = buffer_size;
				
		//Operaciones de conversion: necesarias para luego trabajar con OpenCV
		CImageFormatConverter conversion;
		conversion.OutputPixelFormat = PixelType_BGR8packed;

		CPylonImage imagen_pylon;
		Mat imagen_opencv;

		//La camara comienza a adquirir
		camara.StartGrabbing(imagenes_a_adquirir);
		//El puntero siguiente recibe el resultado de la grabacion
		CGrabResultPtr ptrGrabResult;

		//Declaracion de variables fuera del bucle
		int img_counter = 1;
		//Poner String_t para guardar pylonImage
		/*String nombre_imagen = "C://PabloRosales//Proyecto//imagenes_binarizadas_roi//img_";
		String png = ".png";*/

		while (camara.IsGrabbing())
		{
			camara.RetrieveResult(5000, ptrGrabResult, TimeoutHandling_ThrowException);
			if (ptrGrabResult->GrabSucceeded())
			{
				camara.ExposureTime.SetValue(t_expo);
				DisplayImage(1, ptrGrabResult);
				++img_counter;
				cout << "Fotograma " << img_counter << endl;

				//Conversion de la imagen del buffer a una imagen tipo Pylon
				conversion.Convert(imagen_pylon, ptrGrabResult);
				//Conversion de la imagen tipo Pylon a Mat de OpenCV
				imagen_opencv = cv::Mat(ptrGrabResult->GetHeight(), ptrGrabResult->GetWidth(), CV_8UC3, (uint8_t *)imagen_pylon.GetBuffer());
				/*namedWindow("CALIBRACION", WINDOW_NORMAL);
				imshow("CALIBRACION", imagen_opencv);*/
				waitKey(1);
			}
			else
			{
				cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
			}
		}
		namedWindow("DISTANCIA", WINDOW_NORMAL);
		setMouseCallback("DISTANCIA", CallBackFunc, NULL);
		imshow("DISTANCIA", imagen_opencv);
		waitKey();
		circle(imagen_opencv, punto1, 3, Scalar(0, 255, 0), -1, 8, 0);
		circle(imagen_opencv, punto2, 3, Scalar(0, 255, 0), -1, 8, 0);
		line(imagen_opencv, punto1, punto2, Scalar(0, 255, 0), 3, 8);
		namedWindow("Distancia seleccionada", WINDOW_NORMAL);
		imshow("Distancia seleccionada", imagen_opencv);
		waitKey();

		//Guarda la imagen de calibracin de distancia
		vector<int> parametros_guardado;
		parametros_guardado.push_back(CV_IMWRITE_PNG_COMPRESSION);
		parametros_guardado.push_back(0);
		imwrite(ruta, imagen_opencv, parametros_guardado);

		cout << "Punto 1 : (" << punto1.x << ", " << punto1.y << ")" << endl;
		cout << "Punto 2 : (" << punto2.x << ", " << punto2.y << ")" << endl;
		
		float distancia_mm;
		cout << endl << "Introduzca valor en mm: " << endl;
		cin >> distancia_mm;

		//Clculo de la distancia en pxls
		float distancia_pxl;
		distancia_pxl = sqrt(pow((punto2.x - punto1.x), 2) + pow((punto2.y - punto1.y), 2));
		cout << "Distancia en pxl: " << distancia_pxl << endl;
		
		//1 pixel equivale a los siguientes mm
		float relacion;
		relacion = distancia_mm / distancia_pxl;
		cout << "La relacion mm por pxl es: " << relacion << endl;
		ofstream fs;
		fs.open("C://Dev//Proyecto//Beta//beta//beta//beta//relacion.txt");
		fs << relacion;
		fs.close();

	}
	catch (const GenericException &e)
	{
		//Tratamiento de errores
		cerr << "Excepcion: " << e.GetDescription() << endl;
		exitCode = 1;
	}


	cin.ignore();
	cerr << endl << "Pulse enter para salir" << endl;
	while (cin.get() != '\n');
}

