/*
TRABAJO FIN DE GRADO 1335
DESARROLLO DE UN SISTEMA DE MEDIDA DEL DIMETRO PUPILAR DE ALTA RESPUESTA EN FRECUENCIA Y PARA ESCENARIOS DE BAJA ILUMINACIN
AUTOR: Pablo Rosales Rodrguez, con DNI 12420233A
TUTOR: Alberto Mansilla Gallo

Valladolid, junio de 2019
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SOFTWARE DE ADQUISICIN DE IMGENES
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/*
El archivo de encabezado "volts_measure.h" permite realizar una llamada al programa de LabView que adquiere el luxmetro y as obtener el nivel de iluminancia
en el instante dado. No se emplea porque impide un correcto funcionamiento a altas velocidades (por encima de 15 fps).
Se ha mantenido en el programa para dejar constancia de su existencia.
*/

#include <pylon/PylonIncludes.h>
#include <pylon/PylonGUI.h>
#include <fstream>
#include <chrono>

using namespace Pylon;

// Settings for using Basler USB cameras.
#include <pylon/usb/BaslerUsbInstantCamera.h>
typedef Pylon::CBaslerUsbInstantCamera Camera_t;
typedef CBaslerUsbCameraEventHandler CameraEventHandler_t; // Or use Camera_t::CameraEventHandler_t

using namespace Basler_UsbCameraParams;
using namespace std;


int main()
{
	int exitCode = 0;
	PylonInitialize();
	bool continua = true;


	//GUARDADO DE IMGENES
	int img_counter = 0;
	//Poner String_t para guardar pylonImage
	String_t nombre_imagen = "C://Dev//Proyecto//Pupilometrias//output//3D//5//tres//img_";
	String_t png = ".png";


	//FICHERO DE LUXES
	ofstream xs("luxes.csv");
	xs << "IMAGEN; LUXES; TIEMPO (ms)" << endl;
	
	
	try
	{
		//Se crea un objeto de tipo camara: camara
		Camera_t camera(CTlFactory::GetInstance().CreateFirstDevice());
		//Se imprime la informacion de la camara
		cout << "Dispositivo: " << camera.GetDeviceInfo().GetModelName() << endl;

		//Se abre la cmara
		camera.Open();


		//Se activa la notificacin del evento
		camera.EventNotification.SetValue(EventNotification_On);
		camera.MaxNumBuffer.SetValue(5000);
		camera.AcquisitionFrameRateEnable.SetValue(true);
		camera.AcquisitionFrameRate.SetValue(5);

		//Tiempo de exposicin
		camera.ExposureTime.SetValue(5000);
		//Ganancia de la cmara
		camera.Gain.SetValue(0);
		//Factor de correccin gamma
		camera.Gamma.SetValue(1);


		//Configuracin de los triggers
		camera.TriggerSelector.SetValue(TriggerSelector_FrameBurstStart);
		camera.TriggerMode.SetValue(TriggerMode_Off);
		camera.TriggerSelector.SetValue(TriggerSelector_FrameStart);
		camera.TriggerSource.SetValue(TriggerSource_Line1);
		camera.TriggerMode.SetValue(TriggerMode_On);
		camera.TriggerActivation.SetValue(TriggerActivation_FallingEdge);

		



		cout << "ESPERA AL TRIGGER" << endl;
		camera.StartGrabbing(GrabStrategy_OneByOne, GrabLoop_ProvidedByUser);
		

		//El puntero siguiente recibe el resultado de la grabacion
		CGrabResultPtr ptrGrabResult;
		
		//|| camera.NumQueuedBuffers.GetValue() > 0
		while (camera.IsGrabbing() && continua == true || camera.NumReadyBuffers.GetValue()>1)
		{
			camera.RetrieveResult(5000, ptrGrabResult, TimeoutHandling_ThrowException);
			img_counter++;
			if (img_counter == 1)
			{
				camera.TriggerSelector.SetValue(TriggerSelector_FrameStart);
				camera.TriggerMode.SetValue(TriggerMode_Off);
			}
			
			//GUARDADO DE IMGENES
			String_t nombre = nombre_imagen + to_string(img_counter).c_str() + png;
			CImagePersistence::Save(ImageFileFormat_Png, nombre, ptrGrabResult);

			if (GetAsyncKeyState(VK_ESCAPE))
			{
				continua = false;
				camera.StopGrabbing();
			}
		}

	}
	catch (const GenericException &e)
	{
		cerr << "Excepcion: " << e.GetDescription() << endl;
		exitCode = 1;
	}


	cerr << endl << "Pulse enter para salir" << endl;
	while (cin.get() != '\n');

	return exitCode;
}