/*
TRABAJO FIN DE GRADO 1335
DESARROLLO DE UN SISTEMA DE MEDIDA DEL DIMETRO PUPILAR DE ALTA RESPUESTA EN FRECUENCIA Y PARA ESCENARIOS DE BAJA ILUMINACIN
AUTOR: Pablo Rosales Rodrguez, con DNI 12420233A
TUTOR: Alberto Mansilla Gallo

Valladolid, junio de 2019
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SOFTWARE DE POSTPROCESAMIENTO MANUAL
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include <iostream>
#include <opencv2/opencv.hpp>
#include "operaciones_imagen.h"
#include "problema_circulos.h"
#include <fstream>
#include <string>
#include <vector>

using namespace cv;
using namespace std;

//VARIABLES GLOBALES
Point punto1, punto2, punto3;
int counter = 0;


//TRATAMIENTO DE CLICKS
void CallBackFunc(int event, int x, int y, int flags, void* userdata)
{
	
	if (event == EVENT_LBUTTONDOWN)
	{
		cout << "Posicion: (" << x << ", " << y << ")" << endl;
		if (counter == 0)
		{
			punto1.x = x;
			punto1.y = y;
		}
		else if (counter == 1)
		{
			punto2.x = x;
			punto2.y = y;
		}
		else if (counter == 2)
		{
			punto3.x = x;
			punto3.y = y;
		}
		counter++;
	}
}

int main()
{
	//NMERO DE OJOS A CORREGIR
	int num_ojos = 1;

	//Imgenes
	Mat imagen_input;
	Mat imagen_output;
	Mat imagen_roi;

	//Vector de datos
	vector <long double> radios;

	long double radio;
	Point centro;

	//Ruta de la foto a modificar
	string ruta_input = "C://Dev//Proyecto//pupilometrias//output//Jorge_1//img_46.png";
	string ruta_output = "C://Dev//Proyecto//pupilometrias//procesado//img_46_modificada.png";
	Rect roi;
	int bucle = 1;
	int ojos = 2;
	int contador_radios = 0;
	float offset_x;
	float offset_y;
	int contador_it = 0;

	//Fichero con la relacin pxl-mm
	float relacion;
	ifstream fs_input;
	fs_input.open("C://Dev//Proyecto//Beta//beta//beta//beta//relacion.txt", ios::out);
	fs_input >> relacion;
	fs_input.close();

	imagen_input = imread(ruta_input, CV_LOAD_IMAGE_COLOR);
	imagen_input.copyTo(imagen_output);

	while (ojos == 2)
	{
		while (bucle == 1)
		{
			imagen_input = imread(ruta_input, CV_LOAD_IMAGE_COLOR);
			if (contador_it == 0)
			{
				imagen_input.copyTo(imagen_output);
			}
			namedWindow("Seleccionar ROI", WINDOW_NORMAL);
			roi = selectROI("Seleccionar ROI", imagen_input);
			imagen_roi = imagen_input(roi);
			destroyWindow("Seleccionar ROI");
			namedWindow("ROI", WINDOW_NORMAL);
			setMouseCallback("ROI", CallBackFunc, NULL);
			imshow("ROI", imagen_roi);
			waitKey();
			circle(imagen_roi, punto1, 3, Scalar(0, 0, 255), -1, 8, 0);
			circle(imagen_roi, punto2, 3, Scalar(0, 0, 255), -1, 8, 0);
			circle(imagen_roi, punto3, 3, Scalar(0, 0, 255), -1, 8, 0);
			destroyWindow("ROI");
			namedWindow("Puntos", WINDOW_NORMAL);
			imshow("Puntos", imagen_roi);
			destroyWindow("Puntos");

			//ALGORITMO BASADO EN DETERMINANTES
			circulo::problema_circulos problema(punto1, punto2, punto3);
			long double det_p, det_c, det_d, det_e, radius;
			Point center;

			det_p = problema.get_det(punto1, punto2, punto3, 1);
			det_c = problema.get_det(punto1, punto2, punto3, 2);
			det_d = problema.get_det(punto1, punto2, punto3, 3);
			det_e = problema.get_det(punto1, punto2, punto3, 4);

			center = problema.get_center(det_p, det_c, det_d);
			radius = problema.get_radius(det_p, det_c, det_d, det_e);
			
			

			circle(imagen_roi, center, radius, Scalar(0, 0, 255), 1, 8, 0);
			namedWindow("Pupila", WINDOW_NORMAL);
			imshow("Pupila", imagen_roi);

			waitKey();
			destroyWindow("Pupila");
			bucle = 0;
			contador_it++;
			cout << "Pulse 1 si desea repetirlo" << endl;
			cin >> bucle;
			if (bucle == 1)
			{
				counter = 0;
				contador_it = 0;
			}
			offset_x = roi.x;
			offset_y = roi.y;
			radio = radius;
			centro = Point(center.x + offset_x, center.y + offset_y);
		}
		
		circle(imagen_output, centro, radio, Scalar(0, 0, 255), 3, 8, 0);
		radios.push_back(radio);
		namedWindow("Imagen Salida", WINDOW_NORMAL);
		imshow("Imagen Salida", imagen_output);
		waitKey();
		destroyWindow("Imagen Salida");
		cout << "Introduzca un 2 para modificar un segundo ojo" << endl;
		cin >> ojos;
		if (ojos == 2)
		{
			counter = 0;
			bucle = 1;
		}
		contador_radios++;
	}

	cout << endl;
	if (contador_radios < 2)
	{
		cout << "Primer radio modificado: " << relacion*radios.at(radios.size() - 1) << endl;
	}
	else if (contador_radios > 1)
	{
		cout << "Primer radio modificado: " << relacion*radios.at(radios.size() - 2) << endl;
		cout << "Segundo radio modificado: " << relacion*radios.at(radios.size() - 1) << endl;
	}
	cin.ignore();
	

	//Guarda la imagen obtenida
	vector<int> parametros_guardado;
	parametros_guardado.push_back(CV_IMWRITE_PNG_COMPRESSION);
	parametros_guardado.push_back(0);
	imwrite(ruta_output, imagen_output, parametros_guardado);

	cerr << endl << "Pulse enter para salir" << endl;
	while (cin.get() != '\n');
	return 0;

}