#include "operaciones_imagen.h"
#include <opencv2/opencv.hpp>

using namespace cv;

namespace img
{
	Mat operaciones_imagen::binarize_function(Mat img_fuente, int binary_threshold)
	{
		Mat img_destino;
		threshold(img_fuente, img_destino, binary_threshold, 255, THRESH_BINARY_INV);
		return img_destino;
	}

	Mat operaciones_imagen::canny_function(Mat img_fuente, int value)
	{
		Mat img_destino;
		Canny(img_fuente, img_destino, int(value/3), value, 3);
		return img_destino;
	}

	Rect operaciones_imagen::roi_detection(Mat img_fuente, float mitad_roi, float altura_roi)
	{
		Rect roi(0, (mitad_roi - (altura_roi / 2)), img_fuente.cols, altura_roi);
		return roi;
	}

	

}