#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Apr  9 18:16:41 2024

@author: pablo
"""

import os
from keras.models import Model, load_model
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

#Accedemos a los daos del archivo
archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/Autoencoders/AutoencoderData.npz')

#Modelos de la red neuronal entrenada
directorio_modelos = '/Users/pablo/Documents/IEIA/TFG/MODELOS'
# Cargar el autoencoder
autoencoder = load_model(os.path.join(directorio_modelos, 'autoencoder_model.keras'))
# Cargar el encoder
encoder = load_model(os.path.join(directorio_modelos, 'encoder_model.keras'))


#CARGAMOS A EXEL LOS VALORES DE LOS RESULTADOS

#Esta funcion calcula pca para un escenario
def calcular_valores(escenario):
    
    if int(escenario)<10:
        escenario=escenario.zfill(2)
    ruta = f'/Users/pablo/Documents/IEIA/TFG/DOCUMENTACION/datos_csv/d{escenario}_te.csv'
    X = pd.read_csv(ruta)
    # Explorar los objetos en el archivo NPZ
    print("Contenido del archivo NPZ:")
    for nombre_archivo in archivo_npz.files:
        print(nombre_archivo)
    # Acceder a los datos
    Xmin = archivo_npz['Xmin']
    Xmax = archivo_npz['Xmax']
    UmbralT2 = archivo_npz['UmbralT2']
    UmbralQ = archivo_npz['UmbralQ']
    hm = archivo_npz['hm']
    rmed = archivo_npz['rmed']
    rcov = archivo_npz['rcov']
    hdesv = archivo_npz['hdesv']
    
    # autoencoder = load_model(os.path.join(directorio_modelos, 'autoencoder_model.keras'))

    # # Cargar el encoder
    # encoder = load_model(os.path.join(directorio_modelos, 'encoder_model.keras'))

    Xn=(X-Xmin)/(Xmax-Xmin)

    h=encoder.predict(Xn)
    salida_red=autoencoder.predict(Xn)

    covin = np.linalg.inv(hdesv)
    
    # Calcular la variable estadística
    T2 = np.zeros(h.shape[0])
    
    for i in range (h.shape[0]):
        
        num = h[i] - hm
        T2[i]= np.dot(np.dot(num, covin), num.T)
        
        
    #MOSTRAR GRAFICA DE T2 EN PANTALLA
    n_observaciones = len(T2) # Número de observaciones
    
    
    # Eje x: n observaciones
    eje_x = range(1, n_observaciones + 1)
    
    plt.figure(figsize=(10, 6))
    plt.plot(eje_x, T2, label='T^2', color='blue')
    plt.axhline(y=UmbralT2, color='red', linestyle='--', label='Umbral')
    plt.xlabel('Observaciones')
    plt.ylabel('Valor de T^2')
    plt.title('Vector T^2 y Umbral')
    plt.legend()
    plt.grid(True)
    plt.show()
    
    res=salida_red-Xn
    residuo=res.values
    
    #rcov=np.cov(residuo.T)
    rcovin = np.linalg.inv(rcov)
    # Calcular la variable estadística
    Q = np.zeros(h.shape[0])
    
    for i in range (h.shape[0]):
        
        num1 = residuo[i] - rmed
        
        Q[i]= np.dot(np.dot(num1, rcovin), num1.T)
    
    # MOSTRAR GRAFICA DE Q EN PANTALLA
    n_observaciones = len(Q)# Número de observaciones
    
    
    # Eje x: n observaciones
    eje_x = range(1, n_observaciones + 1)
    # Variable estadística
    
    
    plt.figure(figsize=(10, 6))
    plt.plot(eje_x, Q, label='Q', color='blue')
    plt.axhline(y=UmbralQ, color='red', linestyle='--', label='Umbral')
    plt.xlabel('Observaciones')
    plt.ylabel('Valor de Q')
    plt.title('Vector Q y Umbral')
    plt.legend()
    plt.grid(True)
    plt.show()
    
    print("Escenario: ", escenario)
    
    #IDENTIFICACIONN DE FALLOS
    
    Falsas_alarmas_T=0
    contador=0
    for i in range(160):
        if T2[i]>UmbralT2:
            contador+=1
    Falsas_alarmas_T=(contador/160)*100
    print("Falsas alarmas detectadas: ", Falsas_alarmas_T,)

    Alarmas_detectadas_T = 0 
    contador=0
    for i in range(160,960):
        if T2[i]>UmbralT2:
            contador+=1    
    Alarmas_detectadas_T=(contador/(960-160))*100
    print("Alarmas detectadas: ", Alarmas_detectadas_T, "%")

    #BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR T2 
    Umbral_fallos=10
    fallo=0
    t_fallo_T = 0
    for i in range(len(T2)):  
        if T2[i]>UmbralT2:
            fallo+=1
        else:
            fallo=0
            
        if fallo==10:
            t_fallo_T = i -9
            break
        

    print("El sistema ha fallado en la observación", t_fallo_T)
            

    if t_fallo_T is None:
        print("No se encontraron ", Umbral_fallos ,"fallos consecutivos.")


    #PARA LA VARIABLE Q
    # Recorremos el Q hasta 160 que es donde sabemos que se produce el primer fallo
    Falsas_alarmas_Q=0
    contador=0
    for i in range(160):
        if Q[i]>UmbralQ:
            contador+=1
    Falsas_alarmas_Q=(contador/160)*100
    print("Falsas alarmas detectadas: ", Falsas_alarmas_Q)


    Alarmas_detectadas_Q = 0 
    contador=0
    for i in range(160,960):
        if Q[i]>UmbralQ:
            contador+=1    
    Alarmas_detectadas_Q=(contador/(960-160))*100
    print("Alarmas detectadas: ", Alarmas_detectadas_Q)


    #BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR Q
    Umbral_fallos=10
    falloQ =0
    t_fallo_Q = None
    for i in range(len(Q)):  
        
        if Q[i]>UmbralQ:
            falloQ+=1
        else:
            falloQ=0
            
        if falloQ==10:
            t_fallo_Q = i -9
            break
      

    print("El sistema ha fallado en la observación", t_fallo_Q)
    if t_fallo_Q is None:
        print("No se encontraron ", Umbral_fallos ,"fallos consecutivos.")
        
    return Falsas_alarmas_T, Alarmas_detectadas_T, t_fallo_T, Falsas_alarmas_Q, Alarmas_detectadas_Q, t_fallo_Q


# Lista para almacenar los valores de las variables de cada escenario
valores_por_escenario = []

# Bucle sobre los 21 escenarios
for escenario in range(1, 22):
    # Calcular los valores para el escenario actual
    valores = calcular_valores(str(escenario))
    # Añadir los valores al lista
    valores_por_escenario.append(valores)

# Crear un DataFrame con los valores
df_con_nombres = pd.DataFrame(valores_por_escenario, columns=['FalsasA(T2)', 'Alarmas(T2)', 't_Fallo(T2)', 'FalsasA(Q)', 'Alarmas(Q)', 't_Fallo(Q)'])



# Agregar una columna 'Fallo' al inicio del DataFrame con valores de 1 a 21
df_con_nombres.insert(0, 'Fallo', range(1, 22))

# Crear rutas y poner el nombre del archivo
nombre_archivo='ResultadosLSTM.xlsx'
directorio = '/Users/pablo/Documents/IEIA/TFG/Autoencoders'
ruta_completa=os.path.join(directorio, nombre_archivo)

# Guardar el DataFrame en un archivo Excel
df_con_nombres.to_excel(ruta_completa, index=False)
