#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Nov 20 19:14:09 2025

@author: pablo
"""

import os
from keras.models import load_model
import pandas as pd
import numpy as np

#Accedemos a los datos del archivo
archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/Autoencoders/AutoencoderData.npz')

#Modelos de la red neuronal entrenada
directorio_modelos = '/Users/pablo/Documents/IEIA/TFG/MODELOS'
autoencoder = load_model(os.path.join(directorio_modelos, 'autoencoder_model.keras'))
encoder = load_model(os.path.join(directorio_modelos, 'encoder_model.keras'))

# ================================
# FUNCIÓN PARA CADA ESCENARIO
# ================================
def calcular_valores(escenario):
    
    if int(escenario) < 10:
        escenario = escenario.zfill(2)

    ruta = f'/Users/pablo/Documents/IEIA/TFG/DOCUMENTACION/datos_csv/d{escenario}_te.csv'
    X = pd.read_csv(ruta)

    Xmin = archivo_npz['Xmin']
    Xmax = archivo_npz['Xmax']
    UmbralT2 = archivo_npz['UmbralT2']
    UmbralQ  = archivo_npz['UmbralQ']
    hm = archivo_npz['hm']
    rmed = archivo_npz['rmed']
    rcov = archivo_npz['rcov']
    hdesv = archivo_npz['hdesv']
    
    Xn = (X - Xmin)/(Xmax - Xmax)

    h = encoder.predict(Xn)
    salida_red = autoencoder.predict(Xn)

    covin = np.linalg.inv(hdesv)

    # ---- T2 ----
    T2 = np.zeros(h.shape[0])
    for i in range(h.shape[0]):
        num = h[i] - hm
        T2[i] = np.dot(np.dot(num, covin), num.T)

    res = salida_red - Xn
    residuo = res.values

    rcovin = np.linalg.inv(rcov)

    # ---- Q ----
    Q = np.zeros(h.shape[0])
    for i in range(h.shape[0]):
        num1 = residuo[i] - rmed
        Q[i] = np.dot(np.dot(num1, rcovin), num1.T)

    # ---- t_fallo Q ----
    Umbral_fallos = 10
    contador = 0
    t_fallo_Q = None

    for i in range(len(Q)):
        if Q[i] > UmbralQ:
            contador += 1
        else:
            contador = 0

        if contador == Umbral_fallos:
            t_fallo_Q = i - (Umbral_fallos - 1)
            break

    # ---- CONTRIBUCIONES ----
    if t_fallo_Q is None:
        contrib = np.zeros(X.shape[1])
    else:
        residuo1 = residuo[t_fallo_Q, :]
        contrib = np.square(residuo1).flatten()

    # ---- MÉTRICAS ----
    Falsas_alarmas_T = np.sum(T2[:160] > UmbralT2) / 160 * 100
    Alarmas_detectadas_T = np.sum(T2[160:] > UmbralT2) / (960-160) * 100

    Falsas_alarmas_Q = np.sum(Q[:160] > UmbralQ) / 160 * 100
    Alarmas_detectadas_Q = np.sum(Q[160:] > UmbralQ) / (960-160) * 100

    # devolver valores y contribuciones
    return (Falsas_alarmas_T, Alarmas_detectadas_T, t_fallo_Q,
            Falsas_alarmas_Q, Alarmas_detectadas_Q, t_fallo_Q,
            contrib)


# ================================
# BUCLE DE ESCENARIOS
# ================================
valores_por_escenario = []
contribuciones_dict = {}

for escenario in range(1, 22):
    faT, adT, tfT, faQ, adQ, tfQ, contrib = calcular_valores(str(escenario))

    valores_por_escenario.append([faT, adT, tfT, faQ, adQ, tfQ])
    contribuciones_dict[f"Escenario_{escenario}"] = contrib


# ================================
# TABLA DE RESULTADOS
# ================================
df_con_nombres = pd.DataFrame(
    valores_por_escenario,
    columns=['FalsasA(T2)', 'Alarmas(T2)', 't_Fallo(T2)',
             'FalsasA(Q)',  'Alarmas(Q)',  't_Fallo(Q)']
)

df_con_nombres.insert(0, 'Fallo', range(1, 22))

# ================================
# TABLA DE CONTRIBUCIONES
# ================================
df_contrib = pd.DataFrame(contribuciones_dict)
df_contrib.insert(0, 'Variable', range(1, len(df_contrib)+1))

# ================================
# EXPORTAR A EXCEL (2 HOJAS)
# ================================
nombre_archivo = 'ResultadosAutoencoder_cont.xlsx'
directorio = '/Users/pablo/Documents/IEIA/TFG/Autoencoders'
ruta_completa = os.path.join(directorio, nombre_archivo)

with pd.ExcelWriter(ruta_completa, engine='openpyxl') as writer:
    df_con_nombres.to_excel(writer, sheet_name='Resultados Autoencoder', index=False)
    df_contrib.to_excel(writer, sheet_name='Contribuciones', index=False)

print("Excel generado con éxito en:", ruta_completa)
