#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Jun 15 20:45:09 2024

@author: pablo
"""
import os
from keras.models import Model, load_model
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

# Cargar el archivo NPZ
archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/_Autoencoders/AutoencoderData.npz')
X = pd.read_csv('/Users/pablo/Documents/IEIA/TFG/datos_csv/d06_te.csv')

# Explorar los objetos en el archivo NPZ
print("Contenido del archivo NPZ:")
for nombre_archivo in archivo_npz.files:
    print(nombre_archivo)

# Acceder a los datos
Xmin = archivo_npz['Xmin']
Xmax = archivo_npz['Xmax']
UmbralT2 = archivo_npz['UmbralT2']
UmbralQ = archivo_npz['UmbralQ']
hm = archivo_npz['hm']
rmed = archivo_npz['rmed']
rcov = archivo_npz['rcov']
hdesv = archivo_npz['hdesv']


 
directorio_modelos = '/Users/pablo/Documents/IEIA/TFG/MODELOS'
# Cargar el autoencoder
autoencoder = load_model(os.path.join(directorio_modelos, 'autoencoder_model.keras'))

# Cargar el encoder
encoder = load_model(os.path.join(directorio_modelos, 'encoder_model.keras'))

Xn=(X-Xmin)/(Xmax-Xmin)

h=encoder.predict(Xn)
salida_red=autoencoder.predict(Xn)

#------------------------------------------------------------------------------
# Deteccion de Fallos


#Cálculo de las estadícas para el analisis de componentes principales
###hdesv=np.cov(h.T)
covin = np.linalg.inv(hdesv)

# Calcular la variable estadística
T2 = np.zeros(h.shape[0])

for i in range (h.shape[0]):
    
    num = h[i] - hm
    T2[i]= np.dot(np.dot(num, covin), num.T)

n_observaciones = len(T2) # Número de observaciones


# Eje x: n observaciones
eje_x = range(1, n_observaciones + 1)

plt.figure(figsize=(10, 6))
plt.plot(eje_x, T2, label='T^2', color='blue')
plt.axhline(y=UmbralT2, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de T^2')
plt.title('Vector T^2 y Umbral')
plt.legend()
plt.grid(True)
plt.show()

res=salida_red-Xn
residuo=res.values

#rcov=np.cov(residuo.T)
rcovin = np.linalg.inv(rcov)
# Calcular la variable estadística
Q = np.zeros(h.shape[0])

for i in range (h.shape[0]):
    
    num1 = residuo[i] - rmed
    
    Q[i]= np.dot(np.dot(num1, rcovin), num1.T)

n_observaciones = len(Q)# Número de observaciones


# Eje x: n observaciones
eje_x = range(1, n_observaciones + 1)
# Variable estadística


plt.figure(figsize=(10, 6))
plt.plot(eje_x, Q, label='Q', color='blue')
plt.axhline(y=UmbralQ, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de Q')
plt.title('Vector Q y Umbral')
plt.legend()
plt.grid(True)
plt.show()






#------------------------------------------------------------------------------

# IDENTIFICACIÓN DE FALLOS 

#PARA LA VARIABLE T
# Recorremos el T2 hasta 160 que es donde sabemos que se produce el primer fallo
Falsas_alarmas_T=0
contador=0
for i in range(160):
    if T2[i]>UmbralT2:
        contador+=1
Falsas_alarmas_T=(contador/160)*100
print("Falsas alarmas detectadas: ", Falsas_alarmas_T)

Alarmas_detectadas_T = 0 
contador=0
for i in range(160,len(T2)):
    if T2[i]>UmbralT2:
        contador+=1    
Alarmas_detectadas_T=(contador/(len(T2)-160))*100
print("Alarmas detectadas: ", Alarmas_detectadas_T)

#BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR T2 

Umbral_fallos=10

fallo=0
t_fallo_T = 0
for i in range(len(T2)):  
    if T2[i]>UmbralT2:
        fallo+=1
    else:
        fallo=0
        
    if fallo==Umbral_fallos:
        t_fallo_T = i - Umbral_fallos +1
        
        break

print("El sistema ha fallado en la observación", t_fallo_T)
        

if t_fallo_T is None:
    print("No se encontraron ", Umbral_fallos ,"fallos consecutivos.")


#PARA LA VARIABLE Q
# Recorremos el Q hasta 160 que es donde sabemos que se produce el primer fallo
Falsas_alarmas_Q=0
contador=0
for i in range(160):
    if Q[i]>UmbralQ:
        contador+=1
Falsas_alarmas_Q=(contador/160)*100
print("Falsas alarmas detectadas: ", Falsas_alarmas_Q)


Alarmas_detectadas_Q = 0 
contador=0
for i in range(160,len(Q)):
    if Q[i]>UmbralQ:
        contador+=1    
Alarmas_detectadas_Q=(contador/(len(Q)-160))*100
print("Alarmas detectadas: ", Alarmas_detectadas_Q,"%")


#BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR Q

Umbral_fallos=10

falloQ =0
t_fallo_Q = None
for i in range(len(Q)):  
    
    if Q[i]>UmbralQ:
        falloQ+=1
    else:
        falloQ=0
        
    if falloQ==10:
        t_fallo_Q = i -9
        
        break
    
if t_fallo_Q is not None:
    print("El sistema ha fallado en la observación", t_fallo_Q)
    
    #DIAGNOSTICO DE ERRORES: Calculamos los residuos a partir del fallo
    residuo1 = residuo[t_fallo_Q, :]
    residuo2 = np.square(residuo1).flatten()

    # Crear el gráfico de barras
    plt.figure(figsize=(10, 6))
    plt.bar(range(1, len(residuo2) + 1), residuo2, color='blue')
    plt.xlabel('Índice')
    plt.ylabel('Valor')
    plt.title('Contribuciones al fallo')
    plt.grid(True)
    plt.show()
else:
    print("⚠️ No se pudo calcular el diagnóstico de errores porque no se detectó un fallo claro en Q (t_fallo_Q es None).")



