#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Created on Tue Apr  9 18:16:41 2024

@author: pablo
"""
import pandas as pd
import numpy as np
import os 

archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/DOCUMENTACION/datosPCA.npz')

#---------------------------------------------
# FUNCION PRINCIPAL PARA CALCULAR RESULTADOS
#---------------------------------------------
def calcular_valores(escenario):
    
    if int(escenario) < 10:
        escenario = escenario.zfill(2)

    ruta = f'/Users/pablo/Documents/IEIA/TFG/DOCUMENTACION/datos_csv/d{escenario}_te.csv'
    X = pd.read_csv(ruta)

    # Acceder a los datos
    P = archivo_npz['P']
    Sa = archivo_npz['Sa']
    UmbralT2 = archivo_npz['UmbralT2']
    umbral_Q = archivo_npz['umbral_Q']
    media_por_columna = archivo_npz['media_por_columna']
    desvTyp_Colum = archivo_npz['desvTyp_Colum']

    Xmed = pd.DataFrame(columns=range(1, 53))
    for columna, media in enumerate(media_por_columna, start=1):
        Xmed[columna] = [media] * 960
    
    XDesv = pd.DataFrame(columns=range(1, 53))
    for columna, desv in enumerate(desvTyp_Colum, start=1):
        XDesv[columna] = [desv] * 960
     
    Xn = (X - Xmed.values) / XDesv.values
    Xn_np = Xn.values

    Sa_inv = np.linalg.inv(Sa)

    # ---------- CÁLCULO T2 ----------
    T2 = np.zeros(Xn_np.shape[0])
    for i in range(Xn_np.shape[0]):
        xn = Xn_np[i]
        xn_t = xn.reshape(-1, 1)
        T2[i] = np.dot(np.dot(np.dot(np.dot(xn, P), Sa_inv), P.T), xn_t)

    # ---------- CÁLCULO SPE (Q) ----------
    Q = np.zeros(Xn_np.shape[0])
    Identidad = np.eye(Xn_np.shape[1])
    for i in range(Xn_np.shape[0]):
        xn = Xn_np[i]
        xn_t = xn.reshape(-1,1)
        r = np.dot((Identidad - np.dot(P, P.T)), xn_t)
        Q[i] = np.dot(r.T, r)

    # ---------- DETECCIÓN ----------
    Umbral_fallos = 10
    t_fallo_T = next((i for i in range(len(T2)) if np.all(T2[i:i+Umbral_fallos] > UmbralT2)), 'No Detectado')
    t_fallo_Q = next((i for i in range(len(Q)) if np.all(Q[i:i+Umbral_fallos] > umbral_Q)), 'No Detectado')

    # Falsas alarmas y alarmas detectadas
    Falsas_alarmas_T = (np.sum(T2[:160] > UmbralT2) / 160) * 100
    Alarmas_detectadas_T = (np.sum(T2[160:] > UmbralT2) / (960-160)) * 100

    Falsas_alarmas_Q = (np.sum(Q[:160] > umbral_Q) / 160) * 100
    Alarmas_detectadas_Q = (np.sum(Q[160:] > umbral_Q) / (960-160)) * 100

    #---------------------------------------------
    # CÁLCULO DE CONTRIBUCIONES AL FALLO
    #---------------------------------------------
    if t_fallo_Q == 'No Detectado':
        contrib = np.zeros(52)
    else:
        residuo = np.dot((Identidad - np.dot(P, P.T)), Xn_np[t_fallo_Q, :])
        contrib = np.square(residuo).flatten()

    valores = [Falsas_alarmas_T, Alarmas_detectadas_T, t_fallo_T,
               Falsas_alarmas_Q, Alarmas_detectadas_Q, t_fallo_Q]

    return valores, contrib


# ---------------------------------------------------------
# LISTAS PARA RECOPILAR RESULTADOS
# ---------------------------------------------------------
valores_por_escenario = []
contribuciones_dict = {}

# Bucle sobre los 21 escenarios
for escenario in range(1, 22):
    valores, contrib = calcular_valores(str(escenario))
    valores_por_escenario.append(valores)
    contribuciones_dict[f'IDV_{escenario}'] = contrib


# ---------------------------------------------------------
# TABLA 1: RESULTADOS PCA
# ---------------------------------------------------------
df_con_nombres = pd.DataFrame(
    valores_por_escenario,
    columns=['FalsasA(T2)', 'Alarmas(T2)', 't_Fallo(T2)', 
             'FalsasA(Q)', 'Alarmas(Q)', 't_Fallo(Q)']
)
df_con_nombres.insert(0, 'Fallo', range(1, 22))

# ---------------------------------------------------------
# TABLA 2: CONTRIBUCIONES AL FALLO
# ---------------------------------------------------------
df_contrib = pd.DataFrame(contribuciones_dict)
df_contrib.insert(0, 'Variable', range(1, 53))


# ---------------------------------------------------------
# EXPORTAR LAS DOS TABLAS EN UN MISMO EXCEL
# ---------------------------------------------------------
nombre_archivo = 'Resultados_PCA.xlsx'
directorio = '/Users/pablo/Documents/IEIA/TFG/PCA'
ruta_completa = os.path.join(directorio, nombre_archivo)

with pd.ExcelWriter(ruta_completa, engine='xlsxwriter') as writer:
    df_con_nombres.to_excel(writer, sheet_name='Resultados PCA', index=False)
    df_contrib.to_excel(writer, sheet_name='Contribuciones', index=False)

from openpyxl import load_workbook
from openpyxl.formatting.rule import ColorScaleRule

# Abrimos el archivo excel generado
wb = load_workbook(ruta_completa)

# # ======== HOJA 1: RESULTADOS PCA ===========
# ws1 = wb["Resultados PCA"]

# # Definir rango (desde columna B hasta G, filas 2 a 22)
# color_rule1 = ColorScaleRule(
#     start_type='min', start_color='FFAA0000',     # rojo
#     mid_type='percentile', mid_value=50, mid_color='FFFFFF00',  # amarillo
#     end_type='max', end_color='FF00AA00'           # verde
# )

# ws1.conditional_formatting.add("B2:G22", color_rule1)


# ======== HOJA 2: CONTRIBUCIONES ===========
ws2 = wb["Contribuciones"]

# Todas las columnas de escenarios (B hasta V si son 21)
ultima_col = 1 + len(contribuciones_dict)   # número total de columnas
letras = ws2.cell(row=1, column=ultima_col).column_letter

rango_contrib = f"B2:{letras}53"

color_rule2 = ColorScaleRule(
    start_type='min', start_color='FFAA0000',
    mid_type='percentile', mid_value=50, mid_color='FFFFFF00',
    end_type='max', end_color='FF00AA00'
)

ws2.conditional_formatting.add(rango_contrib, color_rule2)

# Guardamos cambios
wb.save(ruta_completa)



