import numpy as np
import matplotlib.pyplot as plt

# Rango de entrada
x = np.linspace(-10, 10, 400)

# ==== Funciones de activación ====
def sigmoid(x):
    return 1 / (1 + np.exp(-x))

def tanh(x):
    return np.tanh(x)

def relu(x):
    return np.maximum(0, x)

def leaky_relu(x, alpha=0.1):
    return np.where(x > 0, x, alpha * x)

def softmax(x):
    # Estabilización numérica
    exp_x = np.exp(x - np.max(x))
    return exp_x / np.sum(exp_x)

# ==== Lista de funciones y nombres ====
activations = [
    (sigmoid, 'Sigmoide'),
    (tanh, 'Tanh'),
    (relu, 'ReLU'),
    (leaky_relu, 'Leaky ReLU'),
    (softmax, 'Softmax')
]

# ==== Generar y mostrar cada gráfico ====
for func, name in activations:
    plt.figure(figsize=(6, 4))

    # Softmax es vectorial, se grafica diferente
    if name == 'Softmax':
        x_soft = np.linspace(-2, 2, 200)
        X = np.vstack([x_soft - 1, x_soft, x_soft + 1]).T  # tres "clases"
        Y = np.array([softmax(row) for row in X])
        for i in range(Y.shape[1]):
            plt.plot(x_soft, Y[:, i], label=f'Clase {i+1}', linewidth=2)
    else:
        y = func(x)
        plt.plot(x, y, label=name, linewidth=2)

    # Ejes más marcados
    plt.axhline(0, color='gray', linewidth=1.5)
    plt.axvline(0, color='gray', linewidth=1.5)

    # Detalles del gráfico
    plt.title(f'Función de Activación: {name}')
    plt.xlabel('x')
    plt.ylabel('f(x)')
    plt.grid(True, linestyle='--', alpha=0.5)
    plt.legend()
    plt.tight_layout()
    plt.show()
