#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Apr 25 14:17:27 2024
@author: pablo
"""

import numpy as np
import pandas as pd
from keras.layers import Input, Dense, LeakyReLU
from keras.models import Model
from tensorflow.keras.optimizers import Adam


#Datos y normalizacion de datos
#X = pd.read_csv('/Users/pablo/Documents/4ºIEIA/TFG/DOCUMENTACION/datos_csv/d00_te.csv')
X1 = pd.read_csv('/Users/pablo/Documents/fault_free_testing.csv')


X=X1.iloc[:240000, 3:]
Xmin=X.min(axis=0)
Xmax=X.max(axis=0)
#normalizacion entre 0 y 1
X_normalized=(X-Xmin)/(Xmax-Xmin)



def create_autoencoder5(layer_dims, validation_split, batch_size, epochs, X_normalized):
    # Verificar que layer_dims tenga exactamente 3 capas internas
    if len(layer_dims) != 3:
        raise ValueError("layer_dims debe tener exactamente 3 valores.")

    # Definir las dimensiones de entrada y las capas internas
    input_dim = X_normalized.shape[1]
    encoding_dim1, encoding_dim2, encoding_dim3 = layer_dims

    # Capa de entrada
    input_data = Input(shape=(input_dim,))
    # Capas de codificación
    encoded1 = Dense(encoding_dim1, activation='relu')(input_data)
    encoded2 = Dense(encoding_dim2, activation='relu')(encoded1)
    hidden = Dense(encoding_dim3)(encoded2)
    hidden = LeakyReLU(alpha=0.1)(hidden)   
    # Capas de decodificación
    decoded2 = Dense(encoding_dim2, activation='relu')(hidden)
    decoded1 = Dense(encoding_dim1, activation='relu')(decoded2)
    decoded_output = Dense(input_dim, activation='sigmoid')(decoded1)

    # Extraer el modelo encoder para obtener las representaciones reducidas
    encoder = Model(input_data, hidden)

    # Modelo de autoencoder
    autoencoder = Model(input_data, decoded_output)

    # Compilar el modelo
    autoencoder.compile(optimizer=Adam(), loss='mse')

    # Entrenar el autoencoder
    history = autoencoder.fit(X_normalized, X_normalized,
                              epochs=epochs,
                              batch_size=batch_size,
                              validation_split=validation_split,
                              shuffle=True)

    return autoencoder, encoder, history




# Ejemplo de uso
autoencoder, encoder, history = create_autoencoder5(layer_dims=[48, 35, 24], validation_split=0.2, batch_size=64, epochs=30, X_normalized=X_normalized)

# Para ver la historia del entrenamiento
import matplotlib.pyplot as plt

plt.plot(history.history['loss'])
plt.plot(history.history['val_loss'])
plt.title('Loss del modelo')
plt.ylabel('Loss')
plt.xlabel('Epoch')
plt.legend(['Train', 'Validation'], loc='upper right')
plt.show()

#Almacenamos los parámetros de la capa de salida e interna
salida_red = autoencoder.predict(X_normalized)
h=encoder.predict(X_normalized)

#Cálculo de las estadícas para el analisis de componentes principales
hm=h.mean(axis=0)
hdesv=np.cov(h.T)
covin = np.linalg.inv(hdesv)

# Calcular la variable estadística
T2 = np.zeros(h.shape[0])

for i in range (h.shape[0]):
    
    num = h[i] - hm
    
    T2[i]= np.dot(np.dot(num, covin), num.T)

n_observaciones = len(T2)# Número de observaciones

UmbralT2 = np.percentile(T2, 99)  # Umbral para SPE

# Eje x: n observaciones
eje_x = range(1, n_observaciones + 1)
# Variable estadística


plt.figure(figsize=(10, 6))
plt.plot(eje_x, T2, label='T^2', color='blue')
plt.axhline(y=UmbralT2, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de T^2')
plt.title('Vector T^2 y Umbral')
plt.legend()
plt.grid(True)
plt.show()

res=salida_red-X_normalized
residuo=res.values
rmed=residuo.mean(axis=0)
rcov=np.cov(residuo.T)
rcovin = np.linalg.inv(rcov)
# Calcular la variable estadística
Q = np.zeros(h.shape[0])

for i in range (h.shape[0]):
    
    num1 = residuo[i] - rmed
    
    Q[i]= np.dot(np.dot(num1, rcovin), num1.T)

n_observaciones = len(Q)# Número de observaciones

UmbralQ = np.percentile(Q, 99)  # Umbral para SPE

# Eje x: n observaciones
eje_x = range(1, n_observaciones + 1)
# Variable estadística


plt.figure(figsize=(10, 6))
plt.plot(eje_x, Q, label='Q', color='blue')
plt.axhline(y=UmbralQ, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de Q')
plt.title('Vector Q y Umbral')
plt.legend()
plt.grid(True)
plt.show()

#Guardamos datos de entrenamiento en un fichero 
    
np.savez('/Users/pablo/Documents/IEIA/TFG/Autoencoders/AutoencoderData.npz', 
         Xmin=Xmin, Xmax=Xmax, UmbralT2=UmbralT2, UmbralQ=UmbralQ, 
         hm=hm,hdesv=hdesv,rcov=rcov,rmed=rmed)

# Guardar los modelos
autoencoder.save('/Users/pablo/Documents/IEIA/TFG/MODELOS/autoencoder_model.keras')
encoder.save('/Users/pablo/Documents/IEIA/TFG/MODELOS/encoder_model.keras')


print("Modelos guardados.")

