#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Jun 15 20:45:09 2024

@author: pablo
"""

import os
from keras.models import Model, load_model
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt


# Cargar el archivo NPZ
archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/Autoencoders/AutoencoderLSTM_Data.npz')
X = pd.read_csv('/Users/pablo/Documents/IEIA/TFG/datos_csv/d15_te.csv')
# Explorar los objetos en el archivo NPZ
print("Contenido del archivo NPZ:")
for nombre_archivo in archivo_npz.files:
    print(nombre_archivo)

# Acceder a los datos
Xmin = archivo_npz['Xmin']
Xmax = archivo_npz['Xmax']
# scaler =  archivo_npz['scaler']
UmbralT2 = archivo_npz['UmbralT2']
UmbralQ = archivo_npz['UmbralQ']
hm = archivo_npz['hm']
hdesv = archivo_npz['hdesv']
time_steps = archivo_npz['time_steps']


directorio_modelos = '/Users/pablo/Documents/IEIA/TFG/MODELOS'

# Cargar el autoencoder
autoencoder = load_model(os.path.join(directorio_modelos, 'autoencoder_LSTM.keras'))
# Cargar el encoder
encoder = load_model(os.path.join(directorio_modelos, 'encoder_LSTM.keras'))

# Normalizamos la matriz de datos_csv
Xn=(X-Xmin)/(Xmax-Xmin)
Xn=np.array(Xn)

# Creamos las secuencias de datos adaptadas a la red LSTM a partir de la matriz de datos normalizada
Xn_lstm = []
for i in range(len(Xn) - time_steps):
    Xn_lstm.append(Xn[i:i+time_steps])
Xn_lstm = np.array(Xn_lstm)
   
#------------------------------------------------------------------------------
# Deteccion de Fallos





 # Predicción y cálculo del error 
X_pred = autoencoder.predict(Xn_lstm)
 
 # Representación de los valores T² y Q
h = encoder.predict(Xn_lstm)
 
# Para evitar problemas de singularidad
covin = np.linalg.inv(hdesv)


#----- T2 -----#


T2 = np.array([np.dot(np.dot((h[i] - hm), covin), (h[i] - hm).T)for i in range(h.shape[0])])

plt.figure(figsize=(10, 6))
plt.plot(range(1, len(T2) + 1), T2, label='T^2', color='blue')
plt.axhline(y=UmbralT2, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de T^2')
plt.title('Vector T^2 y Umbral')
plt.legend()
plt.grid()
plt.show()

 
 # Calculamos los residuos para obtener Q
res = Xn_lstm - X_pred
residuo = res.reshape(res.shape[0], -1)

#----- Q -----#


Q = np.array([np.dot((residuo[i]), (residuo[i]).T) for i in range(h.shape[0])])
 
plt.figure(figsize=(10, 6))
plt.plot(range(1, len(Q) + 1), Q, label='Q', color='blue')
plt.axhline(y=UmbralQ, color='red', linestyle='--', label='Umbral')
plt.xlabel('Observaciones')
plt.ylabel('Valor de Q')
plt.title('Vector Q y Umbral')
plt.legend()
plt.grid()
plt.show()






#------------------------------------------------------------------------------

# IDENTIFICACIÓN DE FALLOS 

#PARA LA VARIABLE T
# Recorremos el T2 hasta 160 que es donde sabemos que se produce el primer fallo
# De esta manera contabilizamos las alarmas reales y las falsas que ha detectado el modelo
Falsas_alarmas_T=0
contador=0
for i in range(160):
    if T2[i]>UmbralT2:
        contador+=1
Falsas_alarmas_T=(contador/160)*100
print("Falsas alarmas detectadas: ", Falsas_alarmas_T)

Alarmas_detectadas_T = 0 
contador=0
for i in range(160,len(T2)):
    if T2[i]>UmbralT2:
        contador+=1    
Alarmas_detectadas_T=(contador/(len(T2)-160))*100
print("Alarmas detectadas: ", Alarmas_detectadas_T)

#BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR T2 
Umbral_fallos=10
fallo=0
t_fallo_T = 0
for i in range(len(T2)):  
    if T2[i]>UmbralT2:
        fallo+=1
    else:
        fallo=0
        
    if fallo==10:
        t_fallo_T = i -9
        
        break

print("El sistema ha fallado en la observación", t_fallo_T)
        

if t_fallo_T is None:
    print("No se encontraron ", Umbral_fallos ,"fallos consecutivos.")


#PARA LA VARIABLE Q
# Recorremos el Q hasta 160 que es donde sabemos que se produce el primer fallo
Falsas_alarmas_Q=0
contador=0
for i in range(160):
    if Q[i]>UmbralQ:
        contador+=1
Falsas_alarmas_Q=(contador/160)*100
print("Falsas alarmas detectadas: ", Falsas_alarmas_Q)


Alarmas_detectadas_Q = 0 
contador=0
for i in range(160,len(Q)):
    if Q[i]>UmbralQ:
        contador+=1    
Alarmas_detectadas_Q=(contador/(len(Q)-160))*100
print("Alarmas detectadas: ", Alarmas_detectadas_Q,"%")


#BUSCAMOS SI EL SISTEMA FALLA RECORRIENDO EL VECTOR Q
Umbral_fallos=10
falloQ =0
t_fallo_Q = None
for i in range(len(Q)):  
    
    if Q[i]>UmbralQ:
        falloQ+=1
    else:
        falloQ=0
        
    if falloQ==10:
        t_fallo_Q = i -9
        
        break

    
if t_fallo_Q is not None:
    print("El sistema ha fallado en la observación", t_fallo_Q)
    
    #DIAGNOSTICO DE ERRORES: Calculamos los residuos a partir del fallo
    residuo1 = residuo[t_fallo_Q, :]
    residuo2 = np.square(residuo1).flatten()

    # Crear el gráfico de barras
    plt.figure(figsize=(10, 6))
    plt.bar(range(1, len(residuo2) + 1), residuo2, color='blue')
    plt.xlabel('Índice')
    plt.ylabel('Valor')
    plt.title('Contribuciones al fallo')
    plt.grid(True)
    plt.show()
else:
    print("⚠️ No se pudo calcular el diagnóstico de errores porque no se detectó un fallo claro en Q (t_fallo_Q es None).")

