#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Nov 22 20:45:34 2025

@author: pablo
"""

import os
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker
from keras.models import load_model
import pickle
from bic import calcula_BICs

# === CARPETA DE SALIDA ===
output_dir = '/Users/pablo/Documents/IEIA/TFG/Graficas'
os.makedirs(output_dir, exist_ok=True)

# === RUTAS ===
data_path = '/Users/pablo/Documents/IEIA/TFG/Autoencoders/Distributed1_Data.pkl'
model_dir = '/Users/pablo/Documents/IEIA/TFG/MODELOS/Distributed1_Models'
archivo_npz = np.load('/Users/pablo/Documents/IEIA/TFG/Autoencoders/AutoencoderLSTM_Data.npz')

# === Cargar configuraciones del entrenamiento ===
with open(data_path, 'rb') as f:
    results = pickle.load(f)

grupo_nombres = sorted(results.keys(), key=lambda x: int(x[1:-1]))

# Normalización
Xmin = archivo_npz['Xmin']
Xmax = archivo_npz['Xmax']

def create_sequences(X, time_steps):
    return np.array([X[i:i + time_steps] for i in range(len(X) - time_steps)])


# ================================================================
#        MATRIZ FALLO × GRUPO  (Sí/No detección)
# ================================================================
fallos = [f"d{str(i).zfill(2)}" for i in range(1, 22)]
grupos = grupo_nombres

deteccion_matrix = pd.DataFrame("No", index=fallos, columns=grupos)


# ================================================================
#        BUCLE PRINCIPAL PARA LOS 21 FALLOS
# ================================================================
for fallo_id in fallos:

    print(f"\n==============================")
    print(f"🔎 Analizando fallo {fallo_id}")
    print(f"==============================\n")

    # Cargar fichero de fallo
    X_test_path = f"/Users/pablo/Documents/IEIA/TFG/datos_csv/{fallo_id}_te.csv"
    X_test = pd.read_csv(X_test_path)

    # Normalizar
    Xn_test = (X_test - Xmin) / (Xmax - Xmin)
    Xn_test = Xn_test.fillna(0)

    # =========================================================
    #     EVALUAR CADA GRUPO Y REGISTRAR DETECCIÓN
    # =========================================================
    for nombre in grupo_nombres:

        print(f"   → Grupo {nombre}")

        group_data = results[nombre]
        umbral_T2 = group_data['uT2']
        umbral_Q = group_data['uQ']
        hm = group_data['hm']
        hdesv = group_data['hdesv']
        columnas = group_data['columnas']
        time_steps = group_data['time_steps']

        # Subconjunto de columnas
        X_group = Xn_test.iloc[:, columnas]

        # Secuencias
        X_seq = create_sequences(X_group.values, time_steps)

        # Cargar modelos del grupo
        autoencoder = load_model(os.path.join(model_dir, f"{nombre}_autoencoder.keras"))
        encoder = load_model(os.path.join(model_dir, f"{nombre}_encoder.keras"))

        # Predicciones
        X_pred = autoencoder.predict(X_seq, verbose=0)
        h = encoder.predict(X_seq, verbose=0)

        # ===== T² =====
        covin = np.linalg.inv(hdesv)
        T2 = np.array([
            np.dot(np.dot((h[i] - hm), covin), (h[i] - hm).T)
            for i in range(h.shape[0])
        ])

        # ===== Q =====
        res = X_seq - X_pred
        residuo = res.reshape(res.shape[0], -1)
        Q = np.array([np.dot(residuo[i], residuo[i]) for i in range(len(residuo))])

        # ===== DETECCIÓN (10 consecutivos) =====
        t_fallo_T = next((i for i in range(len(T2) - 10)
                          if all(T2[i+j] > umbral_T2 for j in range(10))), None)

        t_fallo_Q = next((i for i in range(len(Q) - 10)
                          if all(Q[i+j] > umbral_Q for j in range(10))), None)

        # Si cualquiera detecta → marcar "Sí"
        if (t_fallo_T is not None) or (t_fallo_Q is not None):
            deteccion_matrix.loc[fallo_id, nombre] = "Sí"


# ================================================================
#        GUARDAR MATRIZ DE DETECCIÓN EN EXCEL
# ================================================================
excel_path = os.path.join(output_dir, "Deteccion_Distribuido1.xlsx")
deteccion_matrix.to_excel(excel_path)

print("\n=================================================")
print("   ✔ MATRIZ DE DETECCIÓN GUARDADA EN:")
print(f"     {excel_path}")
print("=================================================\n")
